/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ImageList.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_VIEW
#include <sol\View.h>
#endif
#ifndef _SOL_DC
#include <sol\DC.h>
#endif

#ifndef _SOL_IMAGELIST
#define _SOL_IMAGELIST

class ImageList : public Object {
	HIMAGELIST  himl;
  public:
	//date="2000.06.26" Changed to take a default argument.
	ImageList(HIMAGELIST img = NULL) {
		himl = img;
	}

	ImageList(int cx, int cy, UINT flags, int cInitial, int cGrow) {
 		himl = ImageList_Create(cx, cy, flags, cInitial, cGrow);
	}

	~ImageList() { 
		if (himl) {	
			ImageList_Destroy(himl);
		}
	}
	BOOL	clear() {
			return (BOOL) ImageList_Remove(himl, -1);
	}
	int		getImageCount() {
			return  ImageList_GetImageCount(himl);
	}
	int		add(HBITMAP hbmImage, HBITMAP hbmMask) {
			return ImageList_Add(himl, hbmImage, hbmMask);
	}
	int		addIcon(HICON hicon) {
			return replaceIcon(-1, hicon);
	}
	BOOL	draw(int i, HDC hdcDst, int x, int y, UINT fStyle) {
			return ImageList_Draw(himl, i, hdcDst, x, y, fStyle);
	}
	BOOL	draw(int i, DC* dc, int x, int y, UINT fStyle) {
			return ImageList_Draw(himl, i, dc->get(), x, y, fStyle);
	}

	int	replaceIcon(int i, HICON hicon) {        
			return ImageList_ReplaceIcon(himl, i, hicon);
	}
	COLORREF setBkColor(COLORREF clrBk) {
			return ImageList_SetBkColor(himl, clrBk);
	}
	COLORREF getBkColor() {
			return ImageList_GetBkColor(himl);
	}
	BOOL	setOverlayImage(int iImage, int iOverlay){
			return ImageList_SetOverlayImage(himl, iImage, iOverlay);
	}
	BOOL	replace(int i, HBITMAP hbmImage, HBITMAP hbmMask) {
			return ImageList_Replace(himl, i, hbmImage, hbmMask);
	}

	int	addMasked(HBITMAP hbmImage, COLORREF crMask) {
			return ImageList_AddMasked(himl, hbmImage, crMask);
	}
	BOOL    drawEx(int i, HDC hdcDst, int x, int y, int dx, int dy,
			 	COLORREF rgbBk, COLORREF rgbFg, UINT fStyle) {
			return ImageList_DrawEx(himl, i, hdcDst, x, y, dx, dy, 
			rgbBk, rgbFg, fStyle);
	}

	BOOL    remove(int i) {
			return  (BOOL)ImageList_Remove(himl, i);
	}
	HICON	getIcon(int i, UINT flags) {
			return  ImageList_GetIcon(himl, i, flags);
	}

 	HIMAGELIST getImageList() {
			return himl;
	}

	void	loadImage(HINSTANCE hi, LPCTSTR lpbmp, int cx, int cGrow, 
				COLORREF crMask, UINT uType, UINT uFlags) {
			himl = ImageList_LoadImage(hi, lpbmp, cx, cGrow, 
				crMask, uType, uFlags);
	}
	BOOL	beginDrag(int iTrack, int dxHotspot, int dyHotspot) {      
			return ImageList_BeginDrag(himl, iTrack, dxHotspot, dyHotspot);
	}

	void	endDrag() {
			ImageList_EndDrag();
	}

	BOOL	dragEnter(int x, int y) {
			return ImageList_DragEnter(NULL, x, y);
	}

	BOOL	dragEnter(HWND hwndLock, int x, int y) {
			return ImageList_DragEnter(hwndLock, x, y);
	}
	BOOL	dragEnter(View* view, int x, int y) {
			return ImageList_DragEnter(view->getWindow(), x, y);
	}

	BOOL	dragLeave(HWND hwndLock) {
			return ImageList_DragLeave(hwndLock);
	}
	BOOL	dragLeave(View* view) {
			return ImageList_DragLeave(view->getWindow());
	}

	BOOL	dragMove(int x, int y) {
			return ImageList_DragMove(x, y);
	}	
	BOOL	setDragCursorImage(int iDrag, int dxHotspot, int dyHotspot) {
			return ImageList_SetDragCursorImage(himl, iDrag, dxHotspot, dyHotspot);
 	}

	BOOL	dragShowNolock(BOOL fShow) {
			return ImageList_DragShowNolock(fShow);
	}
	HIMAGELIST  getDragImage(POINT* ppt,POINT* pptHotspot) {
			return ImageList_GetDragImage(ppt, pptHotspot);
	}
	BOOL	removeAll()  {
			return ImageList_Remove(himl, -1);
	}
	HICON	extractIcon(int i, UINT fstyle) {
	 		return (HICON)ImageList_GetIcon(himl, i, fstyle);
	}
	void	loadBitmap(HINSTANCE hi, char* lpbmp, int cx, int cGrow, COLORREF crMask, 
				UINT type, UINT flag) {
	 		himl = ImageList_LoadImage(hi, lpbmp, cx, cGrow, crMask, type, flag);
	}
	BOOL	getIconSize(int *cx, int *cy) {
			return ImageList_GetIconSize(himl, cx, cy);
	}
	BOOL	setIconSize(int cx, int cy)   {
	  		return ImageList_SetIconSize(himl, cx, cy);
	}
	BOOL	getImageInfo(int i, IMAGEINFO* pImageInfo) {
			return ImageList_GetImageInfo(himl, i, pImageInfo);
	}
	HIMAGELIST merge(HIMAGELIST himl2, int i2, int dx, int dy) {
			int i1 = getImageCount();
	 		return himl = ImageList_Merge(himl, i1, himl2, i2, dx, dy);
	}

	//<added date="2000.06.26">
	void	setImageList(HIMAGELIST hlist) {
		if (himl) {
			ImageList_Destroy(himl);
		}
		himl = hlist;
	}

	HIMAGELIST	detachImageList() {
		HIMAGELIST h = himl;
		himl = NULL;
		return h;
	}
	//</added>
};

#endif
