/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	InetAddress.h
 *
 *****************************************************************************/

// SOL++2000


#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_STRING
#include <sol\String.h>
#endif

#ifndef _SOL_INETADDRESS
#define _SOL_INETADDRESS

class InetAddress :public Object {
	sockaddr_in		address;
	String			dottedAddress;	//1999.08.06
public:
	InetAddress() {
		memset(&address, 0, sizeof(address));
	}
	InetAddress(unsigned short port, unsigned long addr);

	// The port must be in host-byte-order.
	InetAddress(const char* host, unsigned short port);

	sockaddr_in*	getAddress() {
			return &address;
	}

	int			getSize() {
			return sizeof(address);
	}

	unsigned long getHostAddress() {
			return address.sin_addr.s_addr;
	}
	const char*     getDottedAddress() {
			dottedAddress = inet_ntoa(address.sin_addr);
			return (const char*)dottedAddress;
	}

	unsigned short	getPort() {
			return address.sin_port;
	}

	void	setAddress(unsigned long addr) {
			address.sin_addr.s_addr = addr;
			
	}
	void	setPort(unsigned short port) {
			address.sin_port = port;
	}
};

#endif
