/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IntegerField.cpp
 *
 *****************************************************************************/

// SOL++2000


#include <sol\IntegerField.h>

static  const long STYLE = (WS_BORDER|ES_LEFT|ES_AUTOHSCROLL);


IntegerField::IntegerField(View* parent, const char* name, Args& args)
	:Text(parent, name, 
		args.set(XmNstyle, (ulong)STYLE))
{
	entry = NULL;

	limitText(20);
	replaceWindowProc();
	addEventHandler(WM_CHAR, this,
		(Handler)&IntegerField::charIn, NULL);
	addEventHandler(WM_COMMAND, this,
	        (Handler)&IntegerField::charIn, NULL);
	resize(name);
}



Boolean IntegerField::create(View* parent, const char* name, Args& args)
{
	Boolean rc = Text::create(parent, name, 
		args.set(XmNstyle, (ulong)STYLE));

	entry = NULL;

	limitText(30);	//20->30
	replaceWindowProc();
	addEventHandler(WM_CHAR, this,
		(Handler)&IntegerField::charIn, NULL);
	addEventHandler(WM_COMMAND, this,
	        (Handler)&IntegerField::charIn, NULL);
	resize(name);

	return rc;
}

void IntegerField::addCallback(const char* name, Object* object,
		Callback proc, void* data)
{
	if(entry) {
		delete entry;
	}
	entry = new CallbackEntry(name, NULL, object,
				proc, data);
}


long IntegerField::charIn(Event& event)
{
	char line[256];
	WORD word = event.getWParam();
	if(word >= '0' && word <='9') 
		return defaultProc(event);
	if(word == VK_BACK) 
		return defaultProc(event);
	if(word == VK_RETURN) {
		if(entry) {
			Text::getText(line, 255);
			Action action(NULL, event);
        		entry -> setData(line);
        		entry -> call(action);
		}
		return NULL;
	}
	return NULL;
}


void IntegerField::setInteger(int num)
{
	char buffer[32];
	sprintf(buffer, "%d", num);
	Text::setText(buffer);
}


void IntegerField::setLong(long num)
{
	char buffer[32];
	sprintf(buffer, "%ld", num);
	Text::setText(buffer);
}


int IntegerField::getInteger()
{
	char buffer[32];
	getText(buffer, sizeof(buffer));
	return atoi(buffer);
}


long IntegerField::getLong()
{
	char buffer[32];
	getText(buffer, sizeof(buffer));
	return atol(buffer);
}
