/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	LabelGadget.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_GADGET
#include <sol\Gadget.h>
#endif
#ifndef _SOL_FONT
#include <sol\Font.h>
#endif

#ifndef _SOL_LABELGADGET
#define _SOL_LABELGADGET


class LabelGadget :public Gadget {
	BOOL	 status;
	char*	 text;
	Font*	 font;
	COLORREF backColor;
	COLORREF textColor;
	COLORREF selBackColor;
	COLORREF selTextColor;
	int		 margin;
	DWORD	 style;
  public:
	enum {L_LEFT, L_CENTER, L_RIGHT} LabelType;

  public:
	LabelGadget() : Gadget() { }
  	LabelGadget(View* view, const char* label, Args& args);
	~LabelGadget();

	virtual Boolean create(View* view, const char* label, Args& args);

	virtual void draw(DC* dc);
	virtual void draw(DC* dc, int x, int y);
	void	setMargin(int val) { margin = val; }
	void	setStyle(DWORD style1) { style = style1; }
	void	setFont(Font* f) { font = f; }
	void	setFont(Font& f) { font = &f; }

	void	setTextColor(COLORREF color) { textColor = color; }
	void	setBackColor(COLORREF color) { backColor = color; }
	void	setSelTextColor(COLORREF color) { selTextColor = color; }
	void	setSelBackColor(COLORREF color) { selBackColor = color; }
	void	setStatus(BOOL flag) { status = flag; }
};

#endif
