/*********************************************************************

	LineAnalyzer.cpp
				(C) Copyright 1996-1999	TOSHIYUKI ARAI
				ALL RIGHTS RESERVED 
 ********************************************************************/


// SOL++ 3.0

#include <sol\LineAnalyzer.h>


LineAnalyzer::LineAnalyzer()
{
	num = 0;
	separator[num++] = ' ';
	separator[num++] = '\t';
	separator[num++] = ',';
}


int LineAnalyzer::addSeparator(char x)
{
	int rc = False;
	if(num < 5) {
		separator[num++] = x;
		rc = True;
	}
	return rc;
}


void LineAnalyzer::clearSeparator()
{
	num = 0;
}


int LineAnalyzer::isSeparator(char x)
{
	int rc = False;
	for(int i = 0; i< num; i++) {
		if(separator[i] == x) {
			rc = True;
			break;
		}
	}
	return rc;
}


char* LineAnalyzer::getToken(char* line, char* first)
{
	int flag = 0;

	if(*line == NULL) return NULL;

// SOL++ 2.1
//	while(IsSeparator(*line) == True) {
	while(*line !=NULL && isSeparator(*line) == True) {		
		line++;
	}

	while(*line != NULL) {
		if(*line == '"' && *(line+1) == '"') {
			line += 2;
			break;
		}
		if(*line == '"') {
			line++;  
			flag++;
		}
		if(isSeparator(*line) == True && flag == 2) {
			break;
		}
		if(isSeparator(*line) == True && flag == 0) {
			break;
		}
		*first++ = *line++;
	}
	*first = NULL;
	return line;
}



char* LineAnalyzer::getToken(char* line, char* first, int size)
{
	int flag = 0;

	if(*line == NULL) return NULL;

	while(*line !=NULL && isSeparator(*line) == True) {		
		line++;
	}

	int len = 1;
	while(*line != NULL) {
		if(*line == '"' && *(line+1) == '"') {
			line += 2;
			break;
		}
		if(*line == '"') {
			line++;  
			flag++;
		}
		if(isSeparator(*line) == True && flag == 2) {
			break;
		}
		if(isSeparator(*line) == True && flag == 0) {
			break;
		}
	
		if(len < size) {
			*first++ = *line++;
			len++;
		}
		else {
			break;
		}
	}
	*first = NULL;
	return line;
}


char* LineAnalyzer::getInteger(char* line, int* value)
{
	char word[10];

	char* ptr = getToken(line, word);
	*value = atoi(word);
	return ptr; 
}


int LineAnalyzer::hexStringToInt(char* str)
{
  	int n;
	if(*str++ =='0' && *str++ == 'x') {
		sscanf(str, "%x", &n);
		return n;
	}
	return 0;
}

