/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	LinkedList.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\LinkedList.h>


LinkedList::LinkedList(Boolean gc1)
{
	entry = NULL;
	gc    = gc1;
}


Boolean LinkedList::addFirst(Object* object)
{
	Boolean rc = True;
	entry = new ListEntry(object, entry);
	if(entry == NULL) {
		rc = False;
	}
	return rc;
}


Boolean LinkedList::add(Object* object)
{
	ListEntry* ptr  = entry;
    ListEntry* prev = ptr;

	ListEntry* newEntry= new ListEntry(object);
	if (newEntry == NULL) {
		return False;
	}

	if (ptr == NULL) {
		entry = newEntry;
	}
	else {
		while (ptr) {
			prev = ptr;
			ptr  = ptr -> getNext();
		}
		prev -> setNext(newEntry);
	}
	return True;
}


Boolean LinkedList::remove(Object* object)
{
	Boolean rc = False;
	ListEntry* ptr  = entry;
	ListEntry* prev = ptr;

	while (ptr) {
		Object* obj = ptr -> getObject();
		if (obj == object && prev == ptr) {
			entry = ptr -> getNext();
			if (gc == False) {
				ptr ->setObject(null);
			}
			delete ptr;
			rc = True;
			break;
		}
		if (obj == object && prev != ptr) {
			prev -> setNext(ptr->getNext());
			if (gc == False) {
				ptr ->setObject(null);
			}

			delete ptr;
			rc = True;
			break;
		}
		else {
			prev = ptr;
			ptr  = ptr -> getNext();
		}
	}
	return rc;
}


LinkedList::~LinkedList()
{
	clear();
}


Boolean LinkedList::isContained(Object* obj)
{
	Boolean rc = False;

	ListEntry* ptr  = entry;

	while (ptr) {
		if (ptr -> getObject() == obj) {
			rc = True;
			break;
		}
		ptr = ptr -> getNext();
	}
	return rc;
}


void LinkedList::clear()
{
	ListEntry* ptr  = entry;
	ListEntry* prev = ptr;

	while (ptr) {
		prev = ptr;
		ptr = ptr -> getNext();
		if (gc == False) {
			prev ->setObject(null);
		}
		delete prev;
	}
	entry = NULL;
}


int LinkedList::getLength() const
{
	ListEntry* ptr = entry;
	int n = 0;
	while(ptr) {
		ptr = ptr -> getNext();
		n++;
	}
	return n;
}


Object* LinkedList::getNth(int n)
{
	int m = 0;	// Start from 0 not 1 in SOL++ 3.0

	Object* object = NULL;
	ListEntry* ptr = entry;

	while(ptr) {
		if(m == n) {
			object = ptr ->getObject();
			break;
		}
		ptr = ptr -> getNext();
		m++;
	}
	return object;
}


// Simple selection sort
void LinkedList::sort(SortDirection dir)
{
	int length = getLength();
	int i = 0;
	ListEntry* ith = entry;
   
    while (i<length-1) {	
		ListEntry* cth = ith;
		ListEntry* jth = ith -> getNext();
		Object*    obj = ith -> getObject();

		while (jth) {
			Object* jthObj = jth->getObject();
			if (dir == ASCENDING) {
				if (jthObj -> compare(obj) > 0) {
					cth = jth;
					obj = jth -> getObject();
				}	
			}
			if (dir == DESCENDING) {
				if (jthObj -> compare(obj) < 0) {
					cth = jth;
					obj = jth -> getObject();
				}	
			}
			jth = jth -> getNext();
		}

		cth -> setObject(ith->getObject());
		ith -> setObject(obj);

		ith = ith -> getNext();
		i++;
	}	// wile
}


void LinkedList::reverse()
{
	ListEntry* ptr = entry;
	ListEntry* rev = NULL;
        
	while (ptr) {
		ListEntry* next = ptr -> getNext();
		ptr -> setNext(NULL);

		if (rev) {
			ptr -> setNext(rev); 
			rev = ptr;
		} else {
			rev = ptr;
		}
		ptr = next;
	}

	entry = rev;
}
