/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ListView.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\ListView.h>
#include <sol\ClientDC.h>

static const long STYLE = (WS_TABSTOP|WS_BORDER|WS_HSCROLL);

ListView::ListView(View* parent, const char* name, Args& args)
	:Primitive(parent, name, 
			args.set(XmNpredefined, TRUE)
			    .set(XmNstyle, (ulong)STYLE)
			    .set(XmNclassName, (ulong)WC_LISTVIEW))
{
	setValues(args);
}


//<added date="2000.02.13">
Boolean ListView::create(View* parent, const char* name, Args& args)
{	
	Boolean rc = Primitive::create(parent, name, 
			args.set(XmNpredefined, TRUE)
			    .set(XmNstyle, (ulong)STYLE)
			    .set(XmNclassName, (ulong)WC_LISTVIEW));

	setValues(args);
	return rc;
}
//</added>


Arg* ListView::getCallbackTable(int* num)
{
	static Arg table[] = {
	{XmNitemChangingCallback,	LVN_ITEMCHANGING},
	{XmNitemChangedCallback,	LVN_ITEMCHANGED},
	{XmNinsertItemCallback,		LVN_INSERTITEM},
	{XmNdeleteItemCallback,		LVN_DELETEITEM},
	{XmNdeleteAllItemsCallback,	LVN_DELETEALLITEMS},
	{XmNbeginLabelEditCallback,	LVN_BEGINLABELEDIT},
	{XmNenableEditCallback,		LVN_ENDLABELEDIT},
	{XmNcolumnClickCallback,	LVN_COLUMNCLICK},
	{XmNbeginDragCallback,		LVN_BEGINDRAG},
	{XmNbeginRDragCallback,		LVN_BEGINRDRAG},
	{XmNgetDispInfoCallback,	LVN_GETDISPINFO},
	{XmNsetDispInfoCallback,	LVN_SETDISPINFO},
	{XmNkeyDownCallback,        LVN_KEYDOWN},	
	};
	
	*num = XtNumber(table);
	return table;
}


void ListView::setColumn(StringList* list, int fmt)
{
	LV_COLUMN column;
	memset(&column, 0, sizeof(LV_COLUMN));
	column.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH;
	column.fmt  = fmt;
	column.cx   = 100;
	int i = 0;
	ClientDC cdc(this);
	
	ListEntry* ptr = list->getEntry();
	while(ptr) {
		String* string = (String*)(ptr->getObject());
		char* str = string->getContents();
		column.pszText = str;
		//2000.04.22
		SIZE size;
		cdc.getTextExtent(str, strlen(str), &size);

		column.cx      = size.cx+10;
		insertColumn(i++, &column);

		ptr = ptr ->getNext();
	}
}


void ListView::setColumn(StringList* list, IntegerList* format)
{
	LV_COLUMN column;
	memset(&column, 0, sizeof(LV_COLUMN));
	column.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH;
	column.cx   = 100;
	int i = 0;
	ClientDC cdc(this);
	ListEntry* ptr = list->getEntry();
	ListEntry* itr = format-> getEntry();
	while (ptr) {
		String* string = (String*)   (ptr -> getObject());
		Integer* integer = (Integer*)(itr -> getObject());
		char* str = string->getContents();
		column.pszText = str;
		column.fmt     = integer -> getContents();
		//2000.04.22
		SIZE size;
		cdc.getTextExtent(str, strlen(str), &size);
		column.cx      = size.cx+10;

		insertColumn(i++, &column);
		ptr = ptr -> getNext();
		itr = itr -> getNext();
	}
}


void ListView::setColumn(char** labels, int num)
{
	LV_COLUMN column;
	memset(&column, 0, sizeof(LV_COLUMN));
	column.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH;
	column.fmt  = LVCFMT_LEFT;
	column.cx   = 100;
	for(int i = 0; i<num; i++) {
		column.pszText = labels[i];
		insertColumn(i, &column);
	}
}


void ListView::setItemState(int i, int data, int mask) 
{ 
	LV_ITEM item;
	memset(&item, 0, sizeof(LV_ITEM));
	item.stateMask = mask;
  	item.state     = data;
  	send( LVM_SETITEMSTATE, (WPARAM)i, (LPARAM)&item);
}

void ListView::getItemText(int i, int subItem, char* text, int textMax)
{ 
	LV_ITEM item;
	memset(&item, 0, sizeof(LV_ITEM));
	item.iSubItem   = subItem;
  	item.cchTextMax = textMax;
  	item.pszText    = text;
  	send(LVM_GETITEMTEXT, (WPARAM)i, (LPARAM)&item);
}


void ListView::setItemText(int i, int subItem, char* text) 
{ 
	LV_ITEM item;
	memset(&item, 0, sizeof(LV_ITEM));
	item.iItem = i;
	item.mask = LVIF_TEXT;
	item.iSubItem = subItem;
	item.pszText  = text;
	item.cchTextMax = strlen(text)+1;
  	send(LVM_SETITEMTEXT, (WPARAM)i, (LPARAM)&item);
}


void ListView::insertLine(int n, char** text, int num)
{
	LV_ITEM item;
	memset(&item, 0, sizeof(LV_ITEM));
	item.mask = LVIF_TEXT;
	item.pszText = text[0];
	item.cchTextMax = strlen(text[0])+1;
	item.iItem = n;
	int m = insertItem(&item);

	for(int i = 1; i<num; i++) {
		setItemText(m, i, text[i]);
	}

}


void ListView::insertLine(int n, StringList* list)
{
	LV_ITEM item;
	memset(&item, 0, sizeof(LV_ITEM));
	item.mask = LVIF_TEXT;
	ListEntry* ptr = list->getEntry();
	String* string = (String*)(ptr -> getObject());
	char* text = string->getContents();
	item.pszText    = text;
	item.cchTextMax = 128;
	item.iItem      = n;
	int m = insertItem(&item);

	ptr = ptr -> getNext();
	int	i = 1;
	while(ptr) {
		string = (String*)(ptr -> getObject());
		char* text = string->getContents();
		setItemText(m, i++, text);
		ptr = ptr -> getNext();
	}
}

