/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MdiChild.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_COMPOSITE
#include <sol\Composite.h>
#endif
#ifndef _SOL_MENUBAR
#include <sol\Menubar.h>
#endif
#ifndef _SOL_MDIFRAME
#include <sol\MdiFrame.h>
#endif

#ifndef _SOL_MDICLIENT
#include <sol\MdiClient.h>
#endif

#ifndef _SOL_MDICHILD
#define _SOL_MDICHILD

class MdiChild :public Composite {
	MenuBar*	menuBar;
	int			subMenuId;
  protected:
	virtual long	mdiActivate(Event& event);
	virtual long	size(Event& event);

	long	destroy(Event& event);
	long	defaultProc(Event& event);
  public:
	MdiChild(): Composite() { }
	MdiChild(MdiClient* parent, const char* name, Args& args);
	
	Boolean create(MdiClient* parent, const char* name, Args& args);

	MenuBar*	getMenuBar()  { return menuBar; }
	void		setViewId(int vid);
	MdiFrame*	getMdiFrame();
};

#endif

