/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MdiFrame.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_APPLICATION
#include <sol\Application.h>
#endif
#ifndef _SOL_COMPOSITE
#include <sol\Composite.h>
#endif
#ifndef _SOL_MENUBAR
#include <sol\Menubar.h>
#endif
#ifndef _SOL_MDICLIENT
#include <sol\MdiClient.h>
#endif
#ifndef _SOL_ACCELERATOR
#include <sol\accelerator.h>
#endif
#ifndef _SOL_TOOLBAR
#include <sol\Toolbar.h>
#endif
#ifndef _SOL_STATUSBAR
#include <sol\Statusbar.h>
#endif

#ifndef _SOL_MDIFRAME
#define _SOL_MDIFRAME

class MdiFrame :public Composite {
	MenuBar*	menuBar;
	int			subMenuId;
	MdiClient*	mdiClient;
	Application& application;
	Accelerator* accel;
	ToolBar*	 toolBar;
	StatusBar*	 statusBar;
  protected:
	long	size(Event& event);
	void	cascade(Action& action) {
			mdiClient -> cascade();
	}
	long	command(Event& event);
	void	iconArrange(Action& action) {
			mdiClient -> iconArrange();
	}
	void	tile(Action& action) {
			mdiClient -> tile();
	}
	virtual long defaultProc(Event& event);

  public:
	MdiFrame(Application& applet, const char* name, Args& args);
	~MdiFrame();
	
	void	    exit(Action& action);
	MenuBar*    getMenuBar()   { return menuBar; }
	int         getSubMenuId() { return subMenuId; }
	MdiClient*  getClient() { return mdiClient; }
	void	    realize();
	void	    setViewId(int vid);
	BOOL	    translate(MSG* msg);
	void		setToolBar(ToolBar* bar) { toolBar = bar; }
	void		setStatusBar(StatusBar* bar) { statusBar = bar; }
	virtual void childActivated(View* view);
};

#endif

