/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PageSetupDialog.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Application.h>
#include <sol\PageSetupDialog.h>


PageSetupDialog::PageSetupDialog(View* parent, const char* name, Args& args)
	:CommonDialog(parent, new PAGESETUPDLG)
{
	PAGESETUPDLG* pd = get();
	memset(pd, 0, sizeof(PAGESETUPDLG));
	pd -> lStructSize = sizeof(PAGESETUPDLG);
	pd -> hInstance  = Application::getInstance();

	if(parent) {
		pd -> hwndOwner = parent -> getWindow();
	}
	pd -> Flags   = PSD_DEFAULTMINMARGINS|PSD_INHUNDREDTHSOFMILLIMETERS;
	setValues(args);
}


PageSetupDialog::~PageSetupDialog() 
{
	PAGESETUPDLG* pd = get();
	delete pd;
}


Boolean PageSetupDialog::create(View* parent, const char* name, Args& args)
{	
	Boolean rc = True;
	CommonDialog::create(parent, new PAGESETUPDLG);

	PAGESETUPDLG* pd = get();
	memset(pd, 0, sizeof(PAGESETUPDLG));
	pd -> lStructSize = sizeof(PAGESETUPDLG);
	pd -> hInstance  = Application::getInstance();

	if(parent) {
		pd -> hwndOwner = parent -> getWindow();
	}
	pd -> Flags   = PSD_DEFAULTMINMARGINS|PSD_INHUNDREDTHSOFMILLIMETERS;
	setValues(args);

	return rc;
}

void PageSetupDialog::getValues(Args& args)
{
	PAGESETUPDLG* pd = get();
	ulong* val = NULL;
	int num   = args.getCount();
	Arg* arg  = args.getArgList();

	for (int i = 0; i<num; i++) {
		const char* name = arg[i].name;
		*val = (ulong)arg[i].value;
		if (name == XmNflags) {
			*val = (ulong)pd->Flags;
			continue;
		}
	}
}


void PageSetupDialog::setValues(Args& args)
{
	PAGESETUPDLG* pd = get();
	ulong val;
	if (args.get(XmNhook, &val)) {
		pd -> Flags |= PSD_ENABLEPAGESETUPHOOK;
		pd -> lpfnPageSetupHook = (HOOKFUN)val;
	}
	if (args.get(XmNtemplateName, &val)) {
		pd -> Flags |= PSD_ENABLEPAGESETUPTEMPLATE;
		pd -> lpPageSetupTemplateName  = (char*)val;
	}
	if (args.get(XmNflags, &val)) {
		pd ->Flags |= (DWORD)val;
	}
}

void PageSetupDialog::popup(Action& action)
{
	int result = pageSetup();
	action.setResult(result);
}


