/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Panel.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Panel.h>


// WS_EX_CONTROLPARENT enables keyboard travseral by TAB key.

Panel::Panel(View* parent, const char* name, Args& args)
	:Composite(parent, name,
				args.set(XmNclassName, "Panel")
					.set(XmNbackground, (COLOR_BTNFACE+1))
					.set(XmNexStyle, (ulong)WS_EX_CONTROLPARENT)
					.set(XmNstyle,   (ulong) WS_CHILD|WS_VISIBLE))
{
	setValues(args);
}


Boolean Panel::create(View* parent, const char* name, Args& args)
{
	Boolean rc = Composite::create(parent, name,
				args.set(XmNclassName, "Panel")
					.set(XmNbackground, (COLOR_BTNFACE+1))
					.set(XmNexStyle, (ulong)WS_EX_CONTROLPARENT)
					.set(XmNstyle,   (ulong) WS_CHILD|WS_VISIBLE));

	setValues(args);

	return rc;
}


long Panel::size(Event& event)
{
	return 0L;
}
