/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PopupView.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.10.09 Added a layout method.
// 2000.02.18
// 2001.03.11 Added a create method.

#ifndef _SOL_COMPOSITE
#include <sol\Composite.h>
#endif

#ifndef _SOL_POPUPVIEW
#define _SOL_POPUPVIEW

class PopupView	:public Composite {
	int	focusId;
	View*	owner;
  protected:

	virtual long close(Event& event);
	virtual long defaultProc(Event& event);
	// 1999.10.09
	virtual void layout(int x, int y, int w, int h);

	void	disableOwner();
	void	enableOwner();
	void	resize();
	long	command(Event& event);

  public:
	PopupView() :Composite() { }
	PopupView(View* parent);

	PopupView(View* parent, const char* name, Args& args);
	virtual Boolean create(View* parent, const char* name, Args& args);

	virtual Boolean create(View* parent);

	void	popdown(Action& action);
	virtual void popup(Action& action);
	void	setFocusId(int id) { focusId = id; }
	void	setPopupFocus();
	void	setOwner(View* view) { owner = view; }
	void	popupAsItIs(Action& action);
	void	popupAt(Action& action);

	static BOOL CALLBACK procedure(HWND hwnd, 
			UINT message, WPARAM wParam, LPARAM lParam);

	void	setViewId(int vid);

	void	centerOn();
};

#endif

