/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Process.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Process.h>


Process::Process(const char* command, DWORD flag) 
{
	memset(&securityAttributes, 0, sizeof(SECURITY_ATTRIBUTES));
	securityAttributes.nLength = sizeof(SECURITY_ATTRIBUTES);
	securityAttributes.bInheritHandle = TRUE;

	memset(&startupInfo, 0, sizeof(STARTUPINFO));
	startupInfo.cb       = sizeof(STARTUPINFO);

	BOOL rc = CreateProcess(NULL,			// pointer to name of executable module 
					(char*)command,			// pointer to command line string

					&securityAttributes,	// pointer to process security attributes

					NULL,					// pointer to thread security attributes 
					TRUE,					// inheritance flag 

					flag,					// creation flags 
					NULL,					// pointer to new environment block 

					NULL,					// pointer to current directory name 
					&startupInfo,			// pointer to STARTUPINFO 
					&processInfo); 			// pointer to PROCESS_INFORMATION  

	if (rc == False) {
		memset(&processInfo, 0, sizeof(processInfo));
	}
}


Process::Process(const char* command, Pipe& pipe, DWORD flag) 
{
	memset(&securityAttributes, 0, sizeof(SECURITY_ATTRIBUTES));
	securityAttributes.nLength = sizeof(SECURITY_ATTRIBUTES);
	securityAttributes.bInheritHandle = TRUE;

	memset(&startupInfo, 0, sizeof(STARTUPINFO));
	startupInfo.cb       = sizeof(STARTUPINFO);

	startupInfo.dwFlags	   = STARTF_USESTDHANDLES;
	startupInfo.hStdOutput = pipe.getWriterHandle();
	startupInfo.hStdInput  = pipe.getReaderHandle();

	BOOL rc = CreateProcess(NULL,			// pointer to name of executable module 
					(char*)command,			// pointer to command line string

					&securityAttributes,	// pointer to process security attributes

					NULL,					// pointer to thread security attributes 
					TRUE,					// inheritance flag 

					flag,					// creation flags 
					NULL,					// pointer to new environment block 

					NULL,					// pointer to current directory name 
					&startupInfo,			// pointer to STARTUPINFO 
					&processInfo); 			// pointer to PROCESS_INFORMATION  

	if (rc == False) {
		memset(&processInfo, 0, sizeof(processInfo));
	}
}

Process::Process(const char* command, Pipe* pipe, DWORD flag) 
{
	memset(&securityAttributes, 0, sizeof(SECURITY_ATTRIBUTES));
	securityAttributes.nLength = sizeof(SECURITY_ATTRIBUTES);
	securityAttributes.bInheritHandle = TRUE;

	memset(&startupInfo, 0, sizeof(STARTUPINFO));
	startupInfo.cb       = sizeof(STARTUPINFO);
	if (pipe) {
		startupInfo.dwFlags	   = STARTF_USESTDHANDLES;
		startupInfo.hStdOutput = pipe -> getWriterHandle();
		startupInfo.hStdInput  = pipe -> getReaderHandle();
	}

	BOOL rc = CreateProcess(NULL,			// pointer to name of executable module 
					(char*)command,			// pointer to command line string

					&securityAttributes,	// pointer to process security attributes

					NULL,					// pointer to thread security attributes 
					TRUE,					// inheritance flag 

					flag,					// creation flags 
					NULL,					// pointer to new environment block 

					NULL,					// pointer to current directory name 
					&startupInfo,			// pointer to STARTUPINFO 
					&processInfo); 			// pointer to PROCESS_INFORMATION  

	if (rc == False) {
		memset(&processInfo, 0, sizeof(processInfo));
	}
}



Boolean  Process::destroy(int code)
{
	Boolean rc = False;
	if (processInfo.hProcess) {
		rc = ::TerminateProcess(processInfo.hProcess, code);
	}
	return rc;
}


HANDLE Process:: getProcessHandle() 
{
	return processInfo.hProcess; 
}


Boolean  Process::suspend()
{
	Boolean rc = False;
	if (processInfo.hThread) {
		rc = ::SuspendThread(processInfo.hThread);
	}
	return rc;
}

Boolean  Process::resume()
{
	Boolean rc = False;
	if (processInfo.hThread) {
		rc = ::ResumeThread(processInfo.hThread);
	}
	return rc;
}

void Process::wait(int interval) 
{
	if (processInfo.hProcess) {
		WaitForSingleObject(processInfo.hProcess, interval);
	}
}

