/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PropertyDialog.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Application.h>
#include <sol\PropertyDialog.h>


PropertyDialog::PropertyDialog(View* parent, const char* caption, Args& args)
	:PopupView(parent)
{
	psh = new PROPSHEETHEADER;
	memset(psh, 0, sizeof(PROPSHEETHEADER));
	pages = 5;	// default
	ulong val = args.get(XmNpages);
	if(val) {
		pages = (int)val;
	}
	curIndex = 0;

	psp = new PROPSHEETPAGE[pages];

	psh->ppsp = (LPCPROPSHEETPAGE)psp;
	psh->nPages = curIndex;
	psh->nStartPage = 0;
	psh->dwSize     = sizeof(PROPSHEETHEADER);
	psh->dwFlags    = PSH_PROPSHEETPAGE; //|PSH_PROPTITLE;

	if(parent) {
		psh -> hwndParent = parent->getWindow();
	}
	psh->hInstance  = Application::getInstance();
	psh->pszCaption = caption;

	setValues(args);
}


PropertyDialog::~PropertyDialog() 
{ 
	delete psh;
	delete [] psp;
}


Boolean PropertyDialog::create(View* parent, const char* caption, Args& args)
{
	Boolean rc = True;

	View::setParent(parent);

	psh = new PROPSHEETHEADER;
	memset(psh, 0, sizeof(PROPSHEETHEADER));
	pages = 5;	// default
	ulong val = args.get(XmNpages);
	if(val) {
		pages = (int)val;
	}
	curIndex = 0;

	psp = new PROPSHEETPAGE[pages];

	psh->ppsp = (LPCPROPSHEETPAGE)psp;
	psh->nPages = curIndex;
	psh->nStartPage = 0;
	psh->dwSize     = sizeof(PROPSHEETHEADER);
	psh->dwFlags    = PSH_PROPSHEETPAGE; //|PSH_PROPTITLE;

	if(parent) {
		psh -> hwndParent = parent->getWindow();
	}
	psh->hInstance  = Application::getInstance();
	psh->pszCaption = caption;

	setValues(args);

	return rc;
}


PROPSHEETPAGE* PropertyDialog::getCurPage() 
{
	if(curIndex<pages) {
		return &psp[curIndex];
	}
	else {
		return NULL;
	}
}

/*
VOID CALLBACK PropertyDialog::SheetCallback(HWND  hwndDlg,	
    UINT  message,	LPARAM  lParam)
{
	if(message == PSCB_INITIALIZED) {
		View* self = (View*)lParam;
		if(self) {
			Application::Add(hwndDlg, self);
		}
	}	
}
*/


BOOL PropertyDialog::addPage(PropertyPage* page) 
{
	BOOL rc = FALSE;
	if(page) {
		if(page->getPageHandle()) {
			send(PSM_ADDPAGE, 0, (LPARAM)page->getPageHandle());
			rc = TRUE;
		}
		curIndex++;
	}
	return rc;
}

void PropertyDialog::popup(Action& action) 
{ 
	psh -> nPages = curIndex;
	action.setResult(::PropertySheet(psh));
}

void PropertyDialog::setValues(Args& args)
{
	ulong val = NULL;
	val = args.get(XmNflags);
	if(val) { 
		psh -> dwFlags |= val;
	}

	val = args.get(XmNicon);
	if(val) { 
		psh -> hIcon = (HICON)val;
	}

	val = args.get(XmNstartPage);
	if(val) {
		psh -> nStartPage = (int)val;
	}
}

