/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Queue.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Queue.h>


Queue::Queue() 
{
	head = NULL;
	tail = NULL;
}

void Queue:: addLast(Object* obj) 
{
	ListEntry* ent = new ListEntry(obj);
	if(head == NULL) {
		head = ent;
		tail = ent;
		return;
	}

	if(tail) {
		tail -> setNext(ent);
		tail = ent;
	}
}


void Queue::addFirst(Object* obj) 
{
	ListEntry* ent = new ListEntry(obj);
	if(head == NULL) {
		head = ent;
		tail = ent;
		return;
	}

	if(head) {
		ent -> setNext(head);
		head = ent;
	}
}


ListEntry*  Queue::get() 
{
	if(head) {
		ListEntry* ent = head;
		head = head -> getNext();
		return ent; 
	}
	else {
		return NULL;
	}
}


ListEntry*  Queue::peek() 
{
	if(head) {
		ListEntry* ent = head;
//		head = head -> GetNext();
		return ent; 
	}
	else {
		return NULL;
	}
}

int  Queue::getLength() 
{
	int n = 0;
	if(head==NULL && tail== NULL) {
		return n;
	}
	if(head) {
		ListEntry* ent = head;
		while(ent) {
			ent = ent -> getNext();
			n++;
		}
	}
	return n;
}

