/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	QuickSorter.cpp
 *
 *****************************************************************************/

// SOL++2000

// 1999.09.04 Modifed run method to match the run method in Thread class.

#include <sol\QuickSorter.h>
#include <sol\stdio.h>
#include <sol\View.h>


void QuickSorter::sort(int array[], int low0, int high0)
{
	int low = low0;
	int high = high0;

	if (high0 > low0) {
		int mid = array[( low0 + high0 ) / 2];

		while (low <= high) {
 			while (low < high0  && array[low] < mid) {
				++low;
			}
 			while (high > low0  && array[high] > mid) {
				--high;
			}

			if (low <= high) {
				int t = array[low];
				array[low] = array[high];
				array[high] = t;
				++low;
				--high;
            }
         }

		if (low0 < high) {
			sort(array, low0, high);
		}

		if (low < high0) {
			sort(array, low, high0);
		}
	}
}


void QuickSorter::sort(char* array[], int low0, int high0)
{
	int low = low0;
	int high = high0;

	if (high0 > low0) {

		char* mid = array[(low0 + high0) / 2];

		while (low <= high) {
 			while (low < high0  && strcmp(array[low], mid) < 0) {
				++low;
			}

 			while (high > low0  && strcmp(array[high], mid) > 0) {
				--high;
			}

			if (low <= high) {
				char* t = array[low];
				array[low]  = array[high];
				array[high] = t;
				++low;
				--high;
            }
         }

		if (low0 < high) {
			sort(array, low0, high);
		}

		if (low < high0) {
			sort(array, low, high0);
		}
	}
}



void QuickSorter::sort(Object* array[], int low0, int high0)
{
	int low = low0;
	int high = high0;

	if (high0 > low0) {

		Object* mid = array[(low0 + high0) / 2];

		while (low <= high) {
 			while (low < high0  && array[low]->compare(mid) <0) {
				++low;
			}

 			while (high > low0  && array[high] -> compare(mid) >0) {
				--high;
			}

			if (low <= high) {
				Object* t = array[low];
				array[low] = array[high];
				array[high] = t;
				++low;
				--high;
            }
         }

		if (low0 < high) {
			sort(array, low0, high);
		}

		if (low < high0) {
			sort(array, low, high0);
		}
	}
}


QuickSorter::QuickSorter(View* view1, long message1)
	:Sorter(),
		view(view1),
		message(message1),
		integers(NULL),
		strings(NULL),
		objects(NULL),
		size(0)
{
}


// 	
void QuickSorter::sort(int* array1, int size1)
{
	integers = array1;
	strings  = NULL;
	objects  = NULL;
	size	 = size1;
	resume();
}



// 
void QuickSorter::sort(char** array1, int size1)
{
	integers = NULL;
	strings  = array1;
	objects  = NULL;
	size	 = size1;

	resume();
}


// 
void QuickSorter::sort(Object** objects1, int size1)
{
	integers = NULL;
	strings  = NULL;
	objects  = objects1;
	size	 = size1;

	resume();
}


// 1999.09.04 Modified the return-value and the argument.
void QuickSorter::run() 
{
	if(integers && size>0) {
		sort(integers, 0, size-1);
	}

	if(strings && size>0) {
		sort(strings, 0, size-1);
	}

	if(objects && size>0) {
		sort(objects, 0, size-1);
	}
	if (view) {
		view-> post(message, 0, (LPARAM)this);
	}
}
