/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Registry.cpp
 *
 *****************************************************************************/


// SOL++2000

#include <sol\Registry.h>

Registry::Registry(HKEY hopen)
{
	hopenKey = hopen;
	hkey = NULL;
}


int Registry::create(const char* subkey)
{
	return ::RegCreateKeyEx(hopenKey, subkey, 0, NULL,
				REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, 
				&hkey, NULL);	
}


int Registry::open(const char* subkey)
{
	return ::RegOpenKeyEx(hopenKey, subkey, 0, KEY_QUERY_VALUE, &hkey);	
}


Registry::~Registry()
{
	close();
}


void Registry::close()
{
	if(hkey) {
	 	::RegCloseKey(hkey);
		hkey = NULL;
	}
}

long Registry::enumKey(DWORD index, char* name, DWORD* cbName)
{
	FILETIME lastWrite;
	return ::RegEnumKeyEx(hkey, index, name, cbName, NULL,
				NULL, 0, &lastWrite);
}

long Registry::enumKey(DWORD index, char* name, DWORD* cbName,
		char* cls, DWORD* cbCls, FILETIME* lastWrite)
{
	return ::RegEnumKeyEx(hkey, index, name, cbName, NULL,
				cls, cbCls, lastWrite);
}


long Registry::enumValue(DWORD index, char* value, DWORD* cbValue,
		DWORD* type, BYTE* data, DWORD* cbData)
{
	return ::RegEnumValue(hkey, index, value, cbValue, NULL,
				type, data, cbData);
}

int Registry::setValue(const char* subkey, DWORD type, const char* value, int size)
{
	return ::RegSetValueEx(hkey, subkey, NULL, type, (const byte*) value, size);
}
 

int Registry::getValue(const char* subkey, DWORD* type, char* value, DWORD* size)
{
	return ::RegQueryValueEx(hkey, subkey, NULL, type, (byte*)value, size);
}
