/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Registry.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_REGISTRY
#define _SOL_REGISTRY

class Registry :public Object {
	HKEY	hopenKey;
	HKEY	hkey;
public:
	Registry(HKEY hopen);
	~Registry();
	int	create(const char* subkey);
	void 	close();
	long 	enumKey(DWORD index, char* name, DWORD* cbName);
	long 	enumKey(DWORD index, char* name, DWORD* cbName,
			char* cls, DWORD* cbCls, FILETIME* lastWrite);
	long 	enumValue(DWORD index, char* value, DWORD* cbValue,
			DWORD* type, BYTE* data, DWORD* cbData);

	int 	open(const char* subkey);
	int 	getValue(const char* subkey, DWORD* type, char* value, DWORD* size);
	int 	setValue(const char* subkey, DWORD type, const char* value, int size);
};

#endif

