/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	RichText.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_TEXT
#include <sol\text.h>
#endif

#ifndef _SOL_RICHTEXT
#define _SOL_RICHTEXT
#include <richedit.h>
#include <richole.h>

class RichText :public Text {
	static DWORD CALLBACK streamInProc(DWORD dwCookies, 
				LPBYTE buff, LONG cb, LONG* pcb);
	static DWORD CALLBACK streamOutProc(DWORD dwCookies, 
				LPBYTE buff, LONG cb, LONG* pcb);
  public:

	RichText(): Text() { }
  	RichText(View* parent, const char* name, Args& args);

	virtual Boolean create(View* parent, const char* name, Args& args);

	virtual void 	add(const char* string);
	virtual void	append(const char* string);

	BOOL	canPaste(int cbformat) {
	 		return (BOOL)send(EM_CANPASTE, cbformat, 0);
	}
	Arg*	getCallbackTable(int* num);

	BOOL	displayBand(LPRECT rect) {
			return send(EM_DISPLAYBAND, 0, (LPARAM)rect);
	}
	void	exGetSel(CHARRANGE*  charRange) {
			send(EM_EXGETSEL, 0, (LPARAM)charRange);
	}
	void	exLimitText(int chTextMax) {
			send(EM_EXLIMITTEXT, 0, (LPARAM)chTextMax);
	}
	int		exLineFromChar(DWORD chPos) {
			return (int)send(EM_EXLINEFROMCHAR, 0, (LPARAM)chPos);
	}
	int		exSetSel(CHARRANGE* charRange) {
			return (int)send(EM_EXSETSEL, 0, (LPARAM)charRange);
	}
	int		findText(UINT flag, FINDTEXT* findText) {
			return (int)send(EM_FINDTEXT, (WPARAM)flag, (LPARAM)findText);
	}
	int		findTextEx(UINT flag, FINDTEXTEX* findText) {
			return (int)send(EM_FINDTEXTEX, (WPARAM)flag, (LPARAM)findText);
	}

	DWORD	getCharFormat(BOOL flag, CHARFORMAT* charFormat) {
			return send(EM_GETCHARFORMAT, flag, (LPARAM)charFormat);
	}

	UINT	getEventMask() {
			return (UINT)send(EM_GETEVENTMASK, 	0, 0);
	}

	DWORD	getOptions() {
			return send(EM_GETOPTIONS, 0, 0);
	}

	DWORD	getParaFormat(PARAFORMAT* paraFormat) {
			return send(EM_GETPARAFORMAT, 0, (LPARAM)paraFormat);
	}
	int		getSelText(char* buffer) {
			return send(EM_GETSELTEXT, 0, (LPARAM)buffer);
	}
	UINT	getWordWrapMode() {
			return (UINT)send(EM_GETWORDWRAPMODE, 0, 0);
	}

	void	hideSelection(BOOL fHide, BOOL fChangeStyle) {
			send(EM_HIDESELECTION, (WPARAM)fHide, (LPARAM)fChangeStyle);
	}
	void	pasteSpecial(UINT format) {
			send(EM_PASTESPECIAL, (WPARAM)format, 0);
	}
	void	requestResize() {
			send(EM_REQUESTRESIZE, 0, 0);
	}
	int		selectionType() {
			return send(EM_SELECTIONTYPE, 0, 0);
	}
	COLORREF setBackgroundColor(BOOL flag, COLORREF color) {
			return (COLORREF)send(EM_SETBKGNDCOLOR,(WPARAM)flag,
							(WPARAM)color);
	}
	BOOL	setCharFormat(BOOL flag, CHARFORMAT* format) {
			return (BOOL)send(EM_SETCHARFORMAT, (WPARAM)flag, (LPARAM)format);
	}

	DWORD	setEventMask(DWORD mask) {
			return send(EM_SETEVENTMASK, 0, (LPARAM)mask);
	}

	DWORD	setOleCallback(IRichEditOleCallback* callback) {
			return send(EM_SETOLECALLBACK, 0, (LPARAM)callback);
	}

	DWORD	setOptions(UINT operation, UINT options) {
			return send(EM_SETOPTIONS, (WPARAM)operation, (LPARAM)options);
	}

	BOOL	setParaFormat(PARAFORMAT* format) {
			return (BOOL)send(EM_SETPARAFORMAT, 0, (LPARAM)format);
	}

	BOOL	setTargetDevice(HDC hdc, int lineWidth) {
			return (BOOL)send(EM_SETTARGETDEVICE, (WPARAM)hdc, (LPARAM)lineWidth); 
	}

	UINT	setWordWrapMode(UINT options) {
			return (UINT)send(EM_SETWORDWRAPMODE, (WPARAM)options, 0);
	}
	BOOL	streamIn(const char* filename, UINT format);

	BOOL	streamOut(const char* filename, UINT format);
};

#endif 
