/******************************************************************************
 *
 * Copyright (c) 1999-2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ScrolledRichText.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2001/04/01 Moved the implementation of Constructor and create method.

#include <sol\ScrolledRichText.h>

static const long STYLE	= (WS_VSCROLL|WS_HSCROLL|WS_BORDER|ES_AUTOHSCROLL|\
		 ES_AUTOVSCROLL|ES_WANTRETURN|ES_LEFT|ES_MULTILINE);


ScrolledRichText::ScrolledRichText(View* parent, char* label, Args& args)
	:RichText(parent, label, args.set(XmNstyle, (ulong)STYLE)) 
{

}


Boolean ScrolledRichText::create(View* parent, char* label, Args& args) 
{
	return RichText::create(parent, label, args.set(XmNstyle, (ulong)STYLE));
}


