/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Text.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.16

#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\FileDialog.h>
#include <sol\BinaryTree.h>
//#include <sol\DrawableBinaryTree.h>

#define ID_OPEN 1000
#define ID_SAVE 1001

class AppView :public ApplicationView {
	ScrolledText   sctext;
	FileDialog  	filedlg;
	BinaryTree*  	tree;

	void	open(Action& action)
	{
		filedlg.popup(action);
		if (action.getResult()) {
			sctext.load(filedlg.getFileName());
		}
	}

  public:
	AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args) 
	{
		Args ar;
		sctext.create(this, "", ar);
		sctext.setText("To see an output of this program, previously you have to run Console program of SOL++2000.");
		add(&sctext);

		BinaryNode* root = new BinaryNode(null, "root");
		tree = new BinaryTree(root);
		root -> setLeft(new BinaryNode(root, "left"));
		root -> setRight(new BinaryNode(root, "right"));
		BinaryNode* left = root->getLeft();
		left -> setLeft(new BinaryNode(left, "left-left"));
		left -> setRight(new BinaryNode(left, "left-right"));
		BinaryNode* right = root -> getRight();
		right -> setLeft(new BinaryNode(right, "right-left"));
		right -> setRight(new BinaryNode(right, "right-right"));
		
		root -> configure(1, 1);
		root -> reconfigure();
		root -> print();


		ar.reset();
		ar.set(XmNaccessMode, FileDialog::OPEN);
		filedlg.create(this, NULL, ar);


		addCallback(XmNmenuCallback, ID_OPEN, this,
			(Callback)&AppView::open, NULL);
	}

	~AppView() 
	{
		delete tree;
	}
};



void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appView(applet, name, args);
	appView.realize();
	applet.run();
}
