/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Canvas.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\DrawingArea.h>
#include <sol\Stdio.h>

class CanvasView :public ApplicationView {
	DrawingArea area1;
	DrawingArea area2;
	long	size(Event& event);
	void	draw1(Action& action);
	void	draw2(Action& action);
  public:
	CanvasView(Application& applet, const char* label, Args& args);
};


long CanvasView::size(Event& event)
{
	int w, h;
	event.getSize(w, h);
	area1.reshape(0, 0, w, h/2);
	area2.reshape(0, h/2, w, h/2);
	return 0L;
}


void CanvasView::draw1(Action& action)
{
	PaintDC* pdc = (PaintDC*)action.getValue();
	char* text = (char*)action.getData();

	int x = (int)area1.get(XmNhorizThumbPosition);
	int y = (int)area1.get(XmNvertThumbPosition);
	pdc -> textOut(-x+100, -y+100, text, strlen(text));
}

void CanvasView::draw2(Action& action)
{
	PaintDC* pdc = (PaintDC*)action.getValue();
	char* text = (char*)action.getData();
	int x = (int)area2.get(XmNhorizThumbPosition);
	int y = (int)area2.get(XmNvertThumbPosition);
	pdc -> textOut(-x+100, -y+100, text, strlen(text));
}


CanvasView::CanvasView(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{
	Args ar;
	ar.set(XmNenableThumbTrack, TRUE);
	ar.set(XmNstyle, (ulong)WS_BORDER|WS_VSCROLL|WS_HSCROLL);
	area1.create(this, "", ar);

	ar.reset();
	ar.set(XmNstyle, (ulong)WS_BORDER|WS_VSCROLL|WS_HSCROLL);
	area2.create(this, "", ar);

	area1.addCallback(XmNexposeCallback, this, 
			(Callback)&CanvasView::draw1, "Hello C++ 1");
	area2.addCallback(XmNexposeCallback, this, 
			(Callback)&CanvasView::draw2, "Hello C++ 2");
}


void	Main(int argc, char** argv)
{
	const char* name = "Canvas";
	Application applet(name, argc, argv);

	Args args;
	args.set(XmNwidth,  300);
	args.set(XmNheight, 300);
	CanvasView canvas(applet, name, args);
	canvas.realize();

	applet.run();
}

