/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ClassBrowser.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 1999.09.24 Modified.
// 2000.02.16


#include "ClassBrowser.h"
#include "resource.h"
#include <sol\PaintDC.h>
#include <sol\ClientDC.h>

ClassBrowser::ClassBrowser(Application& applet, const char* caption, Args& args)
	:ApplicationView(applet, caption, args)
{
	range = FALSE;

	Args ar;
	ar.set(XmNfilter, "(Tree *.tre)\0 *.tre\0");
	fileDlg.create(this, "TreeList", ar);

	addCallback(XmNmenuCallback, ID_LOAD, this,
			(Callback)&ClassBrowser::load, NULL);
	addCallback(XmNmenuCallback, ID_EXIT,  this,
			(Callback)&ClassBrowser::exit, NULL);

	ClientDC dc(this);
	UINT charSet = dc.getTextCharsetInfo(NULL);
	ar.reset();
	ar.set(XmNheight, (-12));
	ar.set(XmNcharSet, (ulong)charSet);
	font.create(ar);

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle,   (ulong)WS_CHILD|WS_BORDER|WS_VISIBLE);
	ar.set(XmNscrollBar, TRUE);
	ar.set(XmNlineIncrement, 10);
	ar.set(XmNpageIncrement, 10);
	ar.set(XmNx, 0);
	ar.set(XmNy, 0);
	ar.set(XmNwidth, 100);
	ar.set(XmNheight, 100);
	
	treeView.create(this, "", ar);
	treeView.addCallback(XmNdefaultActionCallback, this,
			(Callback)&ClassBrowser::select, NULL);

	ar.reset();
	headerFile.create(this, "", ar);
	headerFile.setFont(&font);

	ar.reset();
	sourceFile.create(this, "", ar);
	sourceFile.setFont(&font);
}


long ClassBrowser::size(Event& event)
{
	int w, h;
	event.getSize(w, h);
	treeView.reshape(2, 2, w/2-2, h/2-2);
	headerFile.reshape(w/2+2, 2, w/2-4, h/2-2);
	sourceFile.reshape(2, h/2+2, w-4, h/2-4);
	return 0L;
}


void ClassBrowser::load(Action& action)
{
	if (fileDlg.open()) {
		char* fileName = fileDlg.getFileName();
		char buffer[256];
		InheritanceTree* tree = new InheritanceTree();

		if (tree -> load(fileName) == TRUE) {
			sprintf(buffer,"%s - ClassBrowser", fileName);
			setText(buffer);
			// 1999.09.24 
			tree -> setConnectionPolicy(DrawableNode::ZIGZAG);
			tree -> setVertSpacing(10);
			tree -> setFont(&font);
			treeView.setTree(tree);
			treeView.update(NULL);
		}
		else {
			delete tree;
		}
	}
}


void  ClassBrowser::select(Action& action)
{
	DrawableNode* node = (DrawableNode*)action.getValue();
	if(node) {
		InheritanceTree*  tree = (InheritanceTree*)
				treeView.getTree();
		char*   data = (char*) node->getName();

		headerFile.setText("");
		sourceFile.setText("");
		char name[128];
		sprintf(name, "ClassBrowser - %s (%s.h; %s.cpp)",
				 node->getName(), data, data);
		setText(name);

		sprintf(name, "%s\\%s.h", tree->getIncDirectory(), data);
		headerFile.load(name);

		sprintf(name, "%s\\%s.cpp", tree->getSrcDirectory(), data);
		sourceFile.load(name);
	}
}


// Application Main

void	Main(int argc, char** argv)
{
	const char* name = "ClassBrowser";
	Application applet(name, argc, argv);
	Args args;
	args.set(XmNbackground, (COLOR_BTNFACE+1));
	ClassBrowser browser(applet, name, args);
	browser.realize();

	applet.run();
}


