/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Inheritt.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include <sol\FileStream.h>
#include <sol\StringTokenizer.h>
#include "inheritt.h"


InheritanceTree::InheritanceTree()
	:DrawableTree()
{
	setHorizSpacing(15);
	setVertSpacing(8);
	incDirectory = NULL;
	srcDirectory = NULL;
}


InheritanceTree::~InheritanceTree()
{
	delete incDirectory;
	delete srcDirectory;
}


int InheritanceTree::load(char* fileName)
{
	int status = 0;
	char buffer[256];
	char parent[128];
	char word[128];
	char second[128];
	const char* ptr;
	char* data;

	FileStream stream;
	if(stream.openReadOnly(fileName) < 0) {
		return FALSE;
	}

	DrawableNode* node;
	DrawableNode* root;


	while(stream.getLine(buffer, sizeof(buffer)) != FALSE) {
		StringTokenizer analyzer(buffer);
		if(strcmp(buffer, "") ==0) continue;

		ptr = analyzer.getToken(word, sizeof(word));
		if(strcmp(word,"") == 0) continue;

		second[0] = Zero;
		analyzer.getToken(second, sizeof(second));


		if(strcmp(word,"IncDirectory") == 0) {
			incDirectory = new char[strlen(second)+1];
			strcpy(incDirectory, second);
			continue;
		}
		if(strcmp(word,"SrcDirectory") == 0) {
			srcDirectory = new char[strlen(second)+1];
			strcpy(srcDirectory, second);
			continue;
		}

		if(strcmp(word,"{") == 0) {
			status = 1;
			continue;
		}
		if(strcmp(word,"}") == 0) {
			status = 0;
			continue;
		}
		if(strcmp(word,"") !=0 && status == 0) {
			strcpy(parent, word);
			if(getRoot() == NULL) {
				data = new char[strlen(second)+1];
				strcpy(data, second);
				setRoot(new DrawableNode(NULL, parent, data));
			}
			continue;
		}
		if(strcmp(word,"") != 0 && status == 1) {
			root = (DrawableNode*) getRoot();
			node = root -> search(parent);
			data = new char[strlen(second)+1];
			strcpy(data, second);
			node -> add(new DrawableNode(node, word, data));
			continue;
		}
	}
	stream.close();

	root = (DrawableNode*) getRoot();
	root -> configure(0, 0);
	root -> reconfigure();
	return TRUE;
}

