/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	InheritanceTreeView.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include "InheritanceTreeView.h"
#include "pair.h"
#include "resource.h"


InheritanceTreeView::InheritanceTreeView(View* parent, const char* name, Args& args)
	:TreeView(parent, name, args)
{
	int iconSize = 16;

	imageList = new ImageList(iconSize, iconSize, ILC_COLOR, 2,1);

	imageList->setBkColor(::GetSysColor(COLOR_WINDOW));

	HINSTANCE hInst = getInstanceHandle();
	
	iconId1 = imageList->addIcon( 
		::LoadIcon(hInst, MAKEINTRESOURCE(IDI_SDOC)));
	iconId2 = iconId1;	
	setImageList(imageList, 0);
}


InheritanceTreeView::~InheritanceTreeView()
{
	delete imageList;
}


Boolean InheritanceTreeView::create(View* parent, const char* name, Args& args)
{
	Boolean rc = TreeView::create(parent, name, args);

	int iconSize = 16;

	imageList = new ImageList(iconSize, iconSize, ILC_COLOR, 2,1);

	imageList->setBkColor(::GetSysColor(COLOR_WINDOW));

	HINSTANCE hInst = getInstanceHandle();
	
	iconId1 = imageList->addIcon( 
		::LoadIcon(hInst, MAKEINTRESOURCE(IDI_SDOC)));
	iconId2 = iconId1;	
	setImageList(imageList, 0);

	return rc;
}

void InheritanceTreeView::buildTree(HTREEITEM parent, char* parentName,
									LinkedList* pairList)
{
	int length = pairList -> getLength();
	if(length == 0) {
		return;
	}

	HTREEITEM item = (HTREEITEM)TVI_FIRST;

	int n = 1;
	ListEntry* ptr = pairList->getEntry();

	while(ptr) {

		Pair* pair = (Pair*) ptr ->getObject();

		if(pair && strcmp(pair->getParentName(), parentName) == 0) {
			char* childName = pair -> getChildName();
	
			TV_ITEM xitem;
			TV_INSERTSTRUCT insert;
			memset(&xitem, 0, sizeof(TV_ITEM));
			memset(&insert, 0, sizeof(TV_INSERTSTRUCT));
			xitem.mask = TVIF_TEXT|TVIF_PARAM|TVIF_IMAGE;
			xitem.pszText = childName;
			xitem.iImage  = iconId1; 
			xitem.iSelectedImage = iconId2; 
			xitem.lParam  = (LPARAM)pair;

			insert.item = xitem;
			insert.hInsertAfter = item;
			insert.hParent = parent;

			item = insertItem(&insert);

			buildTree(item, childName, pairList);
		}
		ptr = ptr ->getNext();
	}
}
