/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ColorDialog.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\ColorDialog.h>
#include <sol\FontDialog.h>
#include <sol\Brush.h>
#include <sol\PaintDC.h>
#include "resource.h"


class AppView :public ApplicationView {
	COLORREF		color;
	ColorDialog		colordlg;

	long	paint(Event& event) 
	{		 
		PaintDC pdc(this);
		Brush brush(color);
		HGDIOBJ prev = pdc.select(&brush);
		pdc.ellipse(0, 0, 100, 50);
		pdc.select(prev);
		return 0;
	}

	void	setColor(Action& action)
	{
		colordlg.popup(action);
		color = colordlg .getRGBResult();
		update(NULL);
	}

  public:
	AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args)
	{
		color = RGB(0, 0, 255);
		Args ar;
		colordlg.create(this, NULL, ar);
		addCallback(XmNmenuCallback, IDM_COLOR, this,
			(Callback)&AppView::setColor, NULL);
		addCallback(XmNmenuCallback, IDM_EXIT, this,
			(Callback)&AppView::exit, NULL);

		addEventHandler(WM_PAINT, this,
			(Handler)&AppView::paint, NULL);
	}
};


void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appView(applet, name, args);
	appView.realize();
	applet.run();
}

