/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Colormix.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 1999.09.23 Modified
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\Static.h>
#include <sol\ScrollBar.h>
#include <sol\ColorBox.h>
#include <sol\ClientDC.h>


class ColorMixer :public ApplicationView {
	Static	    value[3];
	ScrollBar  scrollbar[3];
	ColorBox   colorbox;

	long	size(Event& event);
	void	scrolled(Action& action);
  public:
	ColorMixer(Application& applet, const char* caption, Args& args);
};


void ColorMixer::scrolled(Action& action)
{
	ScrollBar* scroll = (ScrollBar*)action.getData();
	char  label[10];
	scroll ->getText(label, sizeof(label));
	char  buffer[10];
	sprintf(buffer, "%s%d", label, scroll->getPos());

	for(int i = 0; i<3; i++) {
		if(scroll == &scrollbar[i]) {
			value[i].setText(buffer);
			break;
		}
	}
	int r = scrollbar[0].getPos();
	int g = scrollbar[1].getPos();
	int b = scrollbar[2].getPos();
	colorbox.setColor(RGB(r, g, b));
}


long ColorMixer::size(Event& event)
{
	int w, h;
	event.getSize(w, h);

	ClientDC cdc(this);
	Size size;
	cdc.getTextExtent("A", 1, &size);
	int h1 = size.cy;

	for(int i = 0; i<3; i++) {
		scrollbar[i].reshape(10, 10+(h1+10)*i, w*3/5-10, h1);
		value[i]    .reshape(10+w*3/5, 10+(h1+10)*i, w*2/5-10, h1);
	}
	colorbox.reshape(10, 10+(h1+10)*3, w*3/5-10, h - (10+(h1+10)*4));

	return 0L;
}


ColorMixer::ColorMixer(Application& applet, const char* caption, Args& args)
	:ApplicationView(applet, caption, args)
{
	char name[20];
	static char* names[] = {"R = ", "G = ", "B = "};
	Args ar;
	for(int i = 0; i<3; i++) {
		sprintf(name, "%s%d", names[i], 0);
		ar.reset();
		ar.set(XmNstyle, (ulong)SS_LEFT);
		value[i].create(this, name, ar);
		ar.reset();
		ar.set(XmNminimum,   0);
		ar.set(XmNmaximum, 255);
		ar.set(XmNstyle,   (ulong)SBS_HORZ);
		scrollbar[i].create(this, names[i], ar);
		scrollbar[i].addCallback(XmNhorizScrollCallback, this,
				(Callback)&ColorMixer::scrolled, &scrollbar[i]);
	}
	ar.reset();
	colorbox.create(this, "", ar);
}


void	Main(int argc, char** argv)
{
	const char* appClass = "ColorMixer";
	Application applet(appClass, argc, argv);

	Args args;
	args.set(XmNwidth,  200);
	args.set(XmNheight, 200);
	args.set(XmNbackground, (COLOR_BTNFACE+1));
	ColorMixer mixer(applet, appClass, args);
	mixer.realize();

	applet.run();
}
