/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DiskSpaceViewer.cpp
 *
 *****************************************************************************/


// SOL++2000

#include <sol\ApplicationView.h>
#include <sol\ListView.h>
#include <sol\Profile.h>
#include <sol\Font.h>
#include <sol\Stdio.h>
#include <sol\DiskSpace.h>
#include <sol\StringList.h>



class DiskSpaceViewer :public ApplicationView {
	Profile		profile;
	Font		font;
	ListView	listView;

	DiskSpace	diskSpace;

	const char* getOSName(OSVERSIONINFO ver);
	void	showDiskSpace();
	long	close(Event& event);

  public:
	DiskSpaceViewer(Application& applet, const char* name, Args& args);
	
};


DiskSpaceViewer::DiskSpaceViewer(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;

	int fontSize = -14;
	if(GetSystemMetrics(SM_CXSCREEN) <= 1024 &&
			   GetSystemMetrics(SM_CYSCREEN) <= 768) {
		fontSize = -12;
	}
	ar.reset();
	ar.set(XmNheight, fontSize);
	ar.set(XmNfaceName, "COURIER");
	font.create(ar);

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)LVS_REPORT);
	listView.create(this, "", ar);

	listView.setFont(&font);

	StringList list;
	list.add(new String("Drive"));
	list.add(new String("Free (MB)"));
	list.add(new String("Total(MB)"));
	listView.setColumn(&list);

	// Add sctext to the default layout manager.
	add(&listView);

	addEventHandler(WM_CLOSE, this, (Handler)&DiskSpaceViewer::close, NULL);

	restorePlacement();

	showDiskSpace();
}


const char* DiskSpaceViewer::getOSName(OSVERSIONINFO ver)
{
	const char* name = "Unknown";

	if (ver.dwPlatformId ==VER_PLATFORM_WIN32_WINDOWS) {
		if (ver.dwMinorVersion== 0) {
			name = "Windows 95";
		} else if (ver.dwMinorVersion==10) {
			name = "Windows 98";
		}
	}

	if (ver.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		if (ver.dwMajorVersion==4) {
			name = "Windows NT4.0";
		} else if (ver.dwMajorVersion==5) {
			name = "Windows 2000";
		}
	}
	return name;
}



void DiskSpaceViewer::showDiskSpace()
{
	DWORD drives = GetLogicalDrives();
	int n = 0;

	for (int x= 0; x <26; x++) {
		if (drives & 1 != 0) {
			char d = 'A' + x;
			char buff[3];
			sprintf(buff, "%c:\\", d);
		
			int type = GetDriveType(buff);
		
			if (type == DRIVE_FIXED) {
				double free  =0.0;
				double total = 0.0;
				diskSpace.get(buff, free, total);
				char f[80];
				char t[80];
				sprintf(f, "%6.1f", free);
				sprintf(t, "%6.1f", total);
				StringList list;
				list.add(new String(buff));
				list.add(new String(f));
				list.add(new String(t));
				listView.insertLine(n, &list);
				n++;
			}
		}
		drives = drives >>1;
	}
}


long DiskSpaceViewer::close(Event& event)
{
	savePlacement();
	return defaultProc(event);
}


// DiskSpaceViewer Main
void	Main(int argc, char** argv)
{
	const char* appClass = "DiskSpaceViewer";
	Application applet(appClass, argc, argv);
		
	Args args;
	args.set(XmNclassName, appClass);
	DiskSpaceViewer viewer(applet, appClass, args);
	viewer.realize();
	applet.run();
}

