/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DynamicIcon.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PushButton.h>


class DynamicIcon :public ApplicationView {
	int	    num;
	PushButton** pushb;
	long	size(Event& event);
	void	setIcon(Action& action);
  public:
	DynamicIcon(Application& applet, const char* label, Args& args);
	~DynamicIcon();
};


long DynamicIcon::size(Event& event)
{
	int h = pushb[0]->get(XmNheight);
	for(int i = 0; i<num; i++) {
		pushb[i] -> setLocation(10, 10+(h+10)*i);
	}
	return 0L;
}


void DynamicIcon::setIcon(Action& action)
{
	HICON icon = (HICON)action.getData();
	// Set a new icon.
	set(XmNwindowIcon, (ulong)icon);
	show(SW_MINIMIZE);
}


DynamicIcon::DynamicIcon(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{
	static Arg params[] = {
		{"IDI_APPLICATION",  (ulong)IDI_APPLICATION},
		{"IDI_ASTERISK",     (ulong)IDI_ASTERISK},
		{"IDI_EXCLAMATION",  (ulong)IDI_EXCLAMATION},
		{"IDI_HAND",	     (ulong)IDI_HAND},
		{"IDI_QUESTION",     (ulong)IDI_QUESTION},
	};

	Args ar;
	num = XtNumber(params);
	pushb = new PushButton*[num];

	for(int i = 0; i<XtNumber(params); i++) {
		ar.reset();
		pushb[i] = new PushButton(this, params[i].name,	ar);
		pushb[i] -> addCallback(XmNactivateCallback, this,
				(Callback)&DynamicIcon::setIcon, 
				(void*)LoadIcon(NULL, (char*)params[i].value));
	}
}


DynamicIcon::~DynamicIcon()
{
	for(int i = 0; i<num; i++) {
		delete pushb[i];
	}
	delete [] pushb;
}



//	Sample main
void	Main(int argc, char** argv)
{
	const char* appClass = "DynamicIcon";
	Application applet(appClass, argc, argv);

	Args args;
	args.set(XmNwidth,  300);
	args.set(XmNheight, 300);
	DynamicIcon dicon(applet, appClass, args);
	dicon.realize();

	applet.run();
}

