/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FileExplorer.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.07.01

#include <sol\ApplicationView.h>
#include <sol\Font.h>
#include <sol\Static.h>
#include <sol\TextField.h>
#include <sol\ClientDC.h>
#include <sol\IconedFileList.h>
#include <sol\Stdio.h>
#include "resource.h"

class FileExplorer :public ApplicationView {
	Font		font;
	Static		label;
	TextField   textf;
	IconedFileList	listView;

	int		selectedItem;
	char	currentDir[MAX_PATH];

	void	listUp(Action& action);
	long	size(Event& event);
	long	close(Event& event);

	void	doubleClicked(Action& action);
	void	itemChanged(Action& action);

  public:
	  FileExplorer(Application& applet, const char* caption, Args& args);

};


void FileExplorer::doubleClicked(Action& action) 
{
	char text[MAX_PATH];
	listView.getItemText(selectedItem, 0, text, sizeof(text)-1);

	char temp[MAX_PATH];
	strcpy(temp, text);
	CharLower(temp);

	char dir[_MAX_PATH];
	int len = textf.getText(dir, sizeof(dir)-1);

	char path[MAX_PATH];
	sprintf(path, "%s\\%s", dir, text);

	DWORD attr = ::GetFileAttributes(path);

	if (attr & FILE_ATTRIBUTE_DIRECTORY) {
		Printf("Call findFiles %s\r\n", path);
		textf.setText(path);
		listView.findFiles(path);

	} else if (strstr(temp, ".exe") || strstr(temp, ".com")) {
		Printf("Call WinExec %s\r\n", text);
		::WinExec(path, SW_SHOW);
	} 
}


void FileExplorer::itemChanged(Action& action) 
{
	Event& event = action.getEvent();

	NM_LISTVIEW* nmlistv = (NM_LISTVIEW*)event.getLParam();
	selectedItem = nmlistv->iItem;
}
 

FileExplorer::FileExplorer(Application& applet, 
							const char* caption, Args& args)
	:ApplicationView(applet, caption, args)
{
	selectedItem = -1;

	Args ar;
	ClientDC dc(this);
	ar.set(XmNheight, -12);
	ar.set(XmNcharSet, (ulong)dc.getTextCharsetInfo(NULL));
	font.create(ar);

	ar.reset();
	label.create(this, "Directory:", ar);
	label.setFont(font);
	
	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	textf.create(this, "", ar);
	textf.addCallback(XmNactivateCallback, this,
			(Callback)&FileExplorer::listUp, NULL);
	textf.setFont(font);

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle,  (ulong)LVS_SORTASCENDING | LVS_REPORT);//
	listView.create(this, "", ar);	
	listView.setFont(font);
		
	listView.addCallback(XmNdoubleClickCallback, this,
				(Callback)&FileExplorer::doubleClicked, NULL);
	listView.addCallback(XmNitemChangedCallback, this,
				(Callback)&FileExplorer::itemChanged, NULL);

	addCallback(XmNmenuCallback, IDM_EXIT, this, (Callback)&FileExplorer::exit, NULL);

	addEventHandler(WM_CLOSE, this, (Handler)&FileExplorer::close, NULL);

	char dir[MAX_PATH];
	GetWindowsDirectory(dir, sizeof(dir));
	textf.setText(dir);
	
	restorePlacement();

	listView.findFiles(dir);
}


void FileExplorer::listUp(Action& action) 
{
	char pattern[_MAX_PATH];
	int len = textf.getText(pattern, sizeof(pattern)-1);
	if(len) {
		listView.findFiles(pattern);
		strcpy(currentDir, pattern);
	}
}


long FileExplorer::size(Event& event)
{
	LPARAM l = event.getLParam();
	ClientDC dc(this);
	
	HFONT hfont = (HFONT)dc.select(&font);
	int h = dc.getTextHeight();
	dc.select(hfont);

	label.reshape(0,  0, LOWORD(l), h);
	textf.reshape(0,	 h+2, LOWORD(l), h+8);
	listView.reshape(0,  h*2+12, LOWORD(l), HIWORD(l)-h*2-12);
	return 0L;
}


long FileExplorer::close(Event& event)
{
	// Never forget to call detachImageList method for listView 
	// on Windows95/98.
	listView.detachImageList();
	savePlacement();
	return defaultProc(event);
}

//	FileExplorer main
void	Main(int argc, char** argv)
{
	const char* name = "FileExplorer";
	Application applet(name, argc, argv);

	Args args;
	args.set(XmNbackground, (COLOR_BTNFACE)+1);

	FileExplorer explorer(applet, name, args);
	explorer.realize();

	applet.run();
}
