/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FileListView.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\Static.h>
#include <sol\TextField.h>
#include <sol\ClientDC.h>
#include <sol\ListView.h>
#include <sol\Font.h>
#include <sol\ClientDC.h>

class FileListView :public ApplicationView {
	Font		font;
	Static	    label;
	TextField   textf;
	ListView	listview;
	long    size(Event& event);
	void	listUp(Action& action);	
	void	findFiles(char* pattern);
  public:
	FileListView(Application& applet, const char* caption, Args& args);
};


FileListView::FileListView(Application& applet, const char* caption, Args& args)
        :ApplicationView(applet, caption, args) 
{
	Args ar;
	ClientDC dc(this);
	ar.set(XmNheight, -12);
	ar.set(XmNcharSet, (ulong)dc.getTextCharsetInfo(NULL));
	font.create(ar);

	ar.reset();
	label.create(this, "Filter (Ex. C:\\Windows\\*.*)", ar);
	label.setFont(font);
	
	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	textf.create(this, "", ar);
	textf.addCallback(XmNactivateCallback, this,
			(Callback)&FileListView::listUp, NULL);
	textf.setFont(font);

    ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)LVS_REPORT|LVS_EDITLABELS|LVS_SORTASCENDING);
    listview.create(this, "", ar);

	addCallback(XmNmenuCallback, 101, this,
			(Callback)&FileListView::exit, NULL);

	listview.setFont(font);
		
	StringList list;
	list.add("Name");
	list.add("Size");
	list.add("Date");
	list.add("Time");
	IntegerList format;
	format.add(LVCFMT_LEFT);
	format.add(LVCFMT_RIGHT);
	format.add(LVCFMT_CENTER);
	format.add(LVCFMT_CENTER);

	listview.setColumn(&list, &format);
}

void FileListView::listUp(Action& action)
{	
	char pattern[_MAX_PATH];
	int len = textf.getText(pattern, sizeof(pattern)-1);
	if(len) {
		listview.deleteAllItems();
		findFiles(pattern);
	}
}


void FileListView::findFiles(char* pattern)
{
	WIN32_FIND_DATA data;
	memset(&data, 0, sizeof(WIN32_FIND_DATA));
	data.dwFileAttributes  = FILE_ATTRIBUTE_NORMAL;

	int n = 0;
	StringList list;
	char name[256];
	char size[20];
	char filedate[20];
	char filetime[20];
	HANDLE hf = ::FindFirstFile(pattern, &data);

	while(hf != INVALID_HANDLE_VALUE) {
		sprintf(size, "%d", data.nFileSizeLow);

		SYSTEMTIME time;
		FILETIME ltime;
		::FileTimeToLocalFileTime(&(data.ftLastWriteTime), &ltime);
		::FileTimeToSystemTime(&ltime, &time);
		//<modifed date="2000.02.18" author="to-arai">
		sprintf(filedate, "%.4u/%.2u/%.2u", 
				time.wYear, time.wMonth, time.wDay);
		//</modified>
		sprintf(filetime, "%.2u:%.2u:%.2u", 
				time.wHour, time.wMinute, time.wSecond);

		strcpy(name, (char*)data.cFileName);
		if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			sprintf(name, "%s\\", (char*)data.cFileName);
		}
		list.clear();
		list.add(name); 
		list.add(size);
		list.add(filedate);
		list.add(filetime);
		listview.insertLine(n++, &list);

		if(::FindNextFile(hf, &data)== FALSE){
			::FindClose(hf);
			break;
		}
	}
}


long FileListView::size(Event& event)
{
	LPARAM l = event.getLParam();
	ClientDC dc(this);
	HFONT hfont = (HFONT)dc.select(&font);
	int h = dc.getTextHeight();
	dc.select(hfont);

	int m = 0;
	label.reshape(0,  0, LOWORD(l), h);
	textf.reshape(0,	 h+2, LOWORD(l), h+8);
	listview.reshape(0,  h*2+12, LOWORD(l), HIWORD(l)-h*2-12);
	return 0L;
}


void	Main(int argc, char** argv)
{
	const char* name = "FileListView";
	Application applet(name, argc, argv);

	Args args;
	args.set(XmNbackground, (COLOR_BTNFACE +1));
	FileListView appview(applet, name, args);
	appview.realize();

	applet.run();
}

