/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FindDialog.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 1999.09.24 Modified
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\FindDialog.h>
#include <sol\FileDialog.h>
#include "Resource.h"


class TextEditor :public ApplicationView {
	UINT		findMsg;
	ScrolledText	text;
	FileDialog	fileDialog;
	FindDialog	findDialog;
	long	search(Event& event);
	void	searchDown();
	void	searchUp();
	void	find(Action& action);
	void	open(Action& action);

  public:
	TextEditor(Application& applet, const char* name, Args& args);
};



long TextEditor::search(Event& event) 
{
	DWORD flag = findDialog.getFlag();
	char* find = findDialog.getFindString();
	if(strlen(find) > 0 && (flag & FR_DOWN)) {
		searchDown();
	}
	else {
		searchUp();
		// FR_UP case is not supported.
		MessageBeep(-1);
	}
	return NULL;
}


void TextEditor::searchDown()
{
	int  lines = text.getLineCount();
	char buffer[512];
	char* find = findDialog.getFindString();

	int	start, end;
	text.getSel(&start, &end);
	int line = text.lineFromChar(end);
	int pos  = text.lineIndex(line);

	Boolean flag = FALSE;
	int  n = strlen(find);
	for(int i = line; i<lines; i++) {
		int len = text.getLine(i, buffer, sizeof(buffer));
		buffer[len] = Zero;

		int indx = 0;
		if(line == i) {
			indx = end - pos;
		}
		if(len >= n) {
			for(int j = indx; j<len; j++) {
			    if(strncmp(&buffer[j], find, n) == 0) {
				text.setFocus();
				text.setSel(pos+j, pos+j+n);
				text.scrollCaret();
				flag = TRUE;
				break;
			    }
			}
		}
		pos += (len+2);	
		if(flag) break;
 	 }
}


void TextEditor::searchUp()
{
	int  lines = text.getLineCount();
	char buffer[512];
	char* find = findDialog.getFindString();

	int	start, end;
	text.getSel(&start, &end);
	int line = text.lineFromChar(start);
	int pos  = text.lineIndex(line);

	Boolean flag = FALSE;
	int  n = strlen(find);
	for(int i = line; i>=0; i--) {
		int len = text.getLine(i, buffer, sizeof(buffer));
		buffer[len] = Zero;

		int indx = len-1;
		if(line == i) {
			indx = start - pos;
		}
		if(len >= n) {
			for(int j = indx-1; j>=0; j--) {
			    if(strncmp(&buffer[j], find, n) == 0) {
				setText(&buffer[j]);
				text.setFocus();
				text.setSel(pos+j, pos+j+n);
				text.scrollCaret();

				flag = TRUE;
				break;
			    }
			}
		}
		int lenx = 0;
		if(i>0) {
			lenx = text.getLine(i-1, buffer, sizeof(buffer));
			pos -= (lenx+2);
		}
		if(flag) break;
 	 }
}


void TextEditor::find(Action& action)
{
	if(!findDialog.isWindow()) {
		findDialog.find("");
	}
}


TextEditor::TextEditor(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args) 
{
	Args ar;
	ar.set(XmNnoHideSel, True);
	text.create(this, "", ar);
	// 1999.09.24
	add(text);

	findMsg = RegisterWindowMessage(FINDMSGSTRING);

	ar.reset();
	ar.set(XmNflags, FR_DOWN);
	findDialog.create(this, NULL, ar);

	ar.reset();
	fileDialog.create(this, NULL, ar);

	addCallback(XmNmenuCallback, ID_OPEN, this,
		(Callback)&TextEditor::open, NULL);
	addCallback(XmNmenuCallback, ID_FIND, this,
		(Callback)&TextEditor::find, NULL);

	addCallback(XmNmenuCallback, ID_EXIT, this,
		(Callback)&TextEditor::exit, NULL);

	addEventHandler(findMsg, this,
		(Handler)&TextEditor::search, NULL);
}

void TextEditor::open(Action& action)
{
	if(fileDialog.open()) {
		char* name = fileDialog.getFileName();
		text.load(name);
	}
}


// Sample Main
void	Main(int argc, char** argv)
{
	const char* appClass = "TextEditor";
	Application applet(appClass, argc, argv);

	Args args;
	TextEditor editor(applet, appClass, args);
	editor.realize();
	applet.run();
}

