/******************************************************************************
 *
 * Copyright (c) 1996-2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FontDialog.cpp
 *
 *****************************************************************************/

// Sample program to use FontDialog class of SOL++2000.
// 2000.02.18

#define ID_FONT		102

#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\FontDialog.h>
#include <sol\Font.h>


class AppView :public ApplicationView {
	Font*		font;
	ScrolledText	sctext;
	FontDialog	fontdlg;
	void	setFont(Action& action);
  public:
	AppView(Application& applet, const char* name, Args& args);
	~AppView();
};


void AppView::setFont(Action& action)
{
	fontdlg.popup(action);
	if (action.getResult()) {
		delete font;
		font = fontdlg.getFont();
		sctext.setFont(font);
	}
}

AppView::AppView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	font = null;
	Args ar;
	sctext.create(this, "", ar);
	add(&sctext);

	ar.reset();
	fontdlg.create(this, NULL, ar);
	addCallback(XmNmenuCallback, ID_FONT, this,
		(Callback)&AppView::setFont, NULL);
}

AppView::~AppView()
{
	delete font;
}


void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appView(applet, name, args);
	appView.realize();
	applet.run();
}

