/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HTMLReader.cpp
 *
 *****************************************************************************/

// SOL++2000 Sample
// 2000/11/11

#include <sol\ScrolledRichText.h>
#include <sol\SocketStream.h>
#include <sol\stdio.h>
#include <sol\InetAddress.h>

#include "HTMLReader.h"


HTMLReader::HTMLReader(ScrolledRichText* text, char* u)
	:richText(text),
		url(u),
		proxyHost(""),
		proxyPort(8080)
{
	strcpy(urlString, u);
}


HTMLReader::HTMLReader(ScrolledRichText* text, char* u,
					   const char* host, unsigned short port)
	:richText(text),
		url(u),
		proxyHost(host),
		proxyPort(port)
{
	strcpy(urlString, u);
}


void HTMLReader::readReply(SocketStream* sock)
{			
	int bytes = 0;

	if(!sock) {
		return;
	}

	Boolean err = False;

	// Read header of HTTP response.
	StringBuffer stringBuffer;
	int line = 0; 
	while (sock->readLine(stringBuffer) >2) {
		if (line == 0) {
			Printf("Check Error \r\n");
			const char* reply = stringBuffer.getBuffer();
			if (strstr(reply, "200 OK") ) {
				Printf("HTTP responce OK\r\n");
			}
			else {
				richText->clear();

				Printf("Error %s", stringBuffer.getBuffer());
				richText->append(stringBuffer.getBuffer());
				err = True;
				break;
			}
		}
		//Printf("H>%s", stringBuffer.getBuffer());
		line++;
		stringBuffer.clear();
	}

	if (err == True) {
		return;
	}	

	// Read the body of response.	
	char buffer[1024];
	int size = 0;

	while ( (size = sock->recv(buffer, sizeof(buffer)-1, 0)) >0) {

		buffer[size]= Zero;
		richText->append(buffer);
		//richText->append("\r\n");
		//Printf(">>%s\r\n", (char*)buffer);
	}
}


void HTMLReader::run()
{
	const char* prot = url.getProtocol();
	const char* path = url.getPath();

	if (strcmp(prot, "http") ==0) {
		handleHttp();
	}
	if (strcmp(prot, "file") ==0) {
		readFile();	
	}
}



void HTMLReader::handleHttp()
{
	SocketStream* sock = new SocketStream(AF_INET, 0);

	const char* host    = "";
	unsigned short port = 80;
	const char* pHost = (const char*)proxyHost;

	if (strlen(pHost) == 0) {
		//@Do not use a proxy server.
		host = url.getHost();
		port = url.getPort();
	} else {
		// Use the proxy server of proxyHost.
		host = (const char*)proxyHost;
		port = proxyPort;
	}

	Printf("Host = %s\r\n", host);
	Printf("Port = %d\r\n", port);

	InetAddress inetAddress(host, port);

	int rc = sock->connect(inetAddress);
	if(rc) {
		richText->printf("Could not connect to %s\r\n", urlString);
		sock->shutdown(2);
		delete sock;
		return;
	}

	char buffer[256];
	const char* path = url.getPath();
	Printf("path      %s\r\n", path);
	Printf("urlString %s\r\n", urlString);

	if (pHost != null && strlen(pHost) >0) {
		sprintf(buffer, "GET %s HTTP/1.0\r\n\r\n", urlString);		
	} else {

		if (strlen(path) > 0) {
			sprintf(buffer, "GET /%s HTTP/1.0\r\n\r\n", path);
		} else {
			sprintf(buffer, "GET / HTTP/1.0\r\n\r\n");
		}
	}

	Printf("Sending %s", buffer);
	int len = strlen(buffer);
	sock->sendAll(buffer, len, 0);

	// Read a reply from server.
	readReply(sock);

	sock->shutdown(2);
	delete sock;

}


void HTMLReader::readFile()
{
	const char* fileName = url.getFileName();

	richText->clear();

	Printf("filename [%s]\r\n", fileName);
	FileStream stream;
	if (stream.openReadOnly(fileName)) {
		char line[256];
		while(stream.getLine(line, sizeof(line)-1) >0) {

			//Printf("%s\r\n", line);
			//richText.append(" "); //1999.08.12
			//parser.parse(line);
			richText->append(line);
			richText->append("\r\n");
			Printf(">>%s\r\n", (char*)line);

		}
		stream.close();
	}
}
