/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IPAddressField.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\IPAddressField.h>
#include <sol\FlowLayout.h>
#include <sol\Static.h>

class AppView :public ApplicationView {
	FlowLayout	flowLayout;
	Static		label;
	IPAddressField	addressField;
//	void	exec(Action& action);

  public:
	AppView(Application& applet, const char* name, Args& args);
};


AppView::AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args)
{
	setLayout(&flowLayout);

	Args ar;
	label.create(this, "IPAddress", ar);
	add(label);

	ar.reset();
	ar.set(XmNwidth, 200);
	ar.set(XmNheight, 30);
	addressField.create(this, "", ar);

	Dimension d(200, 30);
	addressField.setPreferredSize(d);
	addressField.setAddress(255, 255, 255, 0);
	add(addressField);

//	addressField -> addCallback(XmNactivateCallback, this,
//		(Callback)exec, NULL);
}


void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);

	Args args;
	args.set(XmNbackground, (COLOR_BTNFACE+1));
	AppView appView(applet, name, args);
	appView.realize();
	applet.run();
}

