/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IconHolder.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\Icon.h>
#include <sol\PaintDC.h>


class IconHolder :public ApplicationView {
	int	  num;
	Icon**    icons;
	long	  paint(Event& event);
  public:
	IconHolder(Application& applet, const char* name, Args& args);
	~IconHolder();
};


IconHolder::IconHolder(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, 
		args.set(XmNstyle, (ulong)WS_VSCROLL|WS_HSCROLL))
{
	num   = 5;
	icons = new Icon*[num];
	int x = 20;
	int y = 20;
	int n = 0;

	icons[n] = new Icon("Application", LoadIcon(NULL,IDI_APPLICATION));
	icons[n++] -> move(x, y); x += 100;

	icons[n] = new Icon("Asterisk",	LoadIcon(NULL,IDI_ASTERISK));
	icons[n++] -> move(x, y); x += 100;

	icons[n] = new Icon("Exclamation", LoadIcon(NULL,IDI_EXCLAMATION));
	icons[n++] -> move(x, y); x += 100;

	icons[n] = new Icon("Hand", LoadIcon(NULL,IDI_HAND));
	icons[n++] -> move(x, y); x += 100;

	icons[n] = new Icon("Question",	LoadIcon(NULL,IDI_QUESTION));
	icons[n++] -> move(x, y); 

	addEventHandler(WM_PAINT, this,
		(Handler)&IconHolder::paint, NULL);
}


IconHolder::~IconHolder()
{
	for(int i = 0; i<num; i++)
		delete icons[i];
}


long IconHolder::paint(Event& event)
{
	PaintDC pdc(this);
	int x     = getScrollPos(SB_HORZ);
	int y     = getScrollPos(SB_VERT);
	for(int i = 0; i<num; i++) {
		icons[i]->draw(pdc.get(), -x, -y);
	}
	return NULL;
}



void	Main(int argc, char** argv)
{
	const char*  appClass= "IconHolder";
	Application applet(appClass, argc, argv);

	Args args;
	args.set(XmNhorizScrollMaximum, 200);
	args.set(XmNvertScrollMaximum,   30);
	IconHolder iconHolder(applet, appClass, args);
	iconHolder.realize();

	applet.run();
}

