/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IconList.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\OwnerDrawListBox.h>
#include <sol\Icon.h>


class IconList :public ApplicationView {
	OwnerDrawListBox  listbox;
	int		num;
	Icon*	icons[10];

	long	close(Event& event);
	long	compareItem(Event& event);
	long	deleteItem(Event& event);
	long	drawItem(Event& event);
	long	measureItem(Event& event);

  public:
	IconList(Application& applet, const char* caption, Args& args);
};


IconList::IconList(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	addEventHandler(WM_CLOSE, this,
		(Handler)&IconList::close, NULL);

	addEventHandler(WM_DRAWITEM, this,
		(Handler)&IconList::drawItem, NULL);
	addEventHandler(WM_MEASUREITEM, this,
		(Handler)&IconList::measureItem, NULL);
	addEventHandler(WM_DELETEITEM, this,
		(Handler)&IconList::deleteItem, NULL);
	addEventHandler(WM_COMPAREITEM, this,
		(Handler)&IconList::compareItem, NULL);

	Args ar;
	ar.set(XmNstyle, (ulong)WS_HSCROLL|LBS_SORT|LBS_MULTICOLUMN);
	listbox.create(this, "", ar);
	// Add this listbox to the defaultLayoutManager.
	add(listbox);

	int width = ::GetSystemMetrics(SM_CXICON);
	listbox.setColumnWidth(width*3);

	num = 0;
	icons[num++] = new Icon("Application",LoadIcon(NULL,IDI_APPLICATION));
	icons[num++] = new Icon("Asterisk",LoadIcon(NULL,IDI_ASTERISK));
	icons[num++] = new Icon("Exclamation",LoadIcon(NULL,IDI_EXCLAMATION));
	icons[num++] = new Icon("Hand",	LoadIcon(NULL,IDI_HAND));
	icons[num++] = new Icon("Question", LoadIcon(NULL,IDI_QUESTION));
	for(int i = 0; i<num; i++) {
		listbox.add(icons[i]);
	}
}


long IconList::close(Event& event)
{
	listbox.resetContent();
	return defaultProc(event);
}


long IconList::compareItem(Event& event)
{
	LPARAM lParam = event.getLParam();
	LPCOMPAREITEMSTRUCT ptr = (LPCOMPAREITEMSTRUCT)lParam;

	Icon* icon1 = (Icon*)(LPSTR) ptr -> itemData1;
	Icon* icon2 = (Icon*)(LPSTR) ptr -> itemData2;

	return strcmp(icon1->getName(), icon2->getName());
}


long IconList::deleteItem(Event& event)
{
	LPARAM lParam = event.getLParam();
	LPDELETEITEMSTRUCT ptr = (LPDELETEITEMSTRUCT)lParam;
	Icon* icon = (Icon*)ptr->itemData;
	delete icon;
	return TRUE;
}


long IconList::drawItem(Event& event)
{
	LPARAM lParam = event.getLParam();
	LPDRAWITEMSTRUCT ptr = (LPDRAWITEMSTRUCT)lParam;
	if(ptr->itemAction == ODA_DRAWENTIRE) {
		RECT rc    = ptr->rcItem;
		Icon* icon = (Icon*) ptr->itemData;
		icon -> draw(ptr->hDC, rc.left+20, rc.top+4);
	}
	return TRUE;
}


long IconList::measureItem(Event& event)
{
	LPARAM lParam = event.getLParam();
	LPMEASUREITEMSTRUCT ptr = (LPMEASUREITEMSTRUCT)lParam;
	int height = ::GetSystemMetrics(SM_CYICON);
	ptr -> itemHeight = height*2;
	return TRUE;
}


void	Main(int argc, char** argv)
{
	const char* appClass = "IconList";
	Application applet(appClass, argc, argv);

	Args	args;
	IconList iconList(applet, appClass, args);
	iconList.realize();

	applet.run();
}

