/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IconViewer.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\Icon.h>
#include <sol\DropFiles.h>
#include "resource.h"


class IconViewer :public ApplicationView {
	int		margin;
	int		max;
	int		num;
	int		pitch;
	int		numPerLine;
	Icon**	icons;

	long	paint(Event& event);
	long	dropFiles(Event& event);
	void	addIcon(const char* name, HICON icon);
  public:
	IconViewer(Application& applet, const char* name, Args& args);
	~IconViewer();
	void  setNumPerLine(UINT value) {
		numPerLine = value;
	}
	void  setPitch(UINT value) {
		pitch = value;
	}
};


IconViewer::IconViewer(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, 
		args.set(XmNstyle, (ulong)WS_VSCROLL|WS_HSCROLL))
{
	margin	   	= 30;
	max	   	= 100;
	num        	= 0;
	pitch	   	= 100;
	numPerLine 	= 5;

	icons = new Icon*[max];
	addEventHandler(WM_PAINT, this, (Handler)&IconViewer::paint, NULL);
	addEventHandler(WM_DROPFILES, this, (Handler)&IconViewer::dropFiles, NULL);

	enableScrollBar(SB_BOTH, 
			ESB_DISABLE_BOTH);
	addCallback(XmNmenuCallback, ID_EXIT, this,(Callback)&IconViewer::exit, NULL);
}


IconViewer::~IconViewer()
{
	for(int i = 0; i<num; i++)
		delete icons[i];
	delete [] icons;
}


long IconViewer::paint(Event& event)
{
	PaintDC pdc(this);
	int x     = getScrollPos(HORIZONTAL);
	int y     = getScrollPos(VERTICAL);
	for(int i = 0; i<num; i++)
		icons[i]->draw(pdc.get(), -x, -y);
	return NULL;
}


void IconViewer::addIcon(const char* name, HICON hicon)
{
	if(num < max) {
		int y = num / numPerLine;
		int x = num % numPerLine;
		AnsiLower((char*)name);
		icons[num] = new Icon(name, hicon);
		icons[num] -> setFlag(TRUE);
		icons[num++] -> move(margin+x*pitch, margin+pitch*y); 

		enableScrollBar(SB_BOTH, ESB_ENABLE_BOTH);
		setScrollRange(SB_VERT, 0, margin+pitch*y);
		setScrollRange(SB_HORZ, 0, margin+pitch*numPerLine);
		setScrollExtent(margin+pitch*y, margin+pitch*numPerLine);
	}
}


long IconViewer::dropFiles(Event& event)
{
	Event* e = (Event*)&event;
	DropFiles	drop((HDROP)event.getWParam());
	int count = drop.queryCount();

	HINSTANCE ins = getInstanceHandle();

	for(int n = 0; n<count; n++) {
		char filename[256];
		drop.queryFile(n, filename, sizeof(filename));
		const char* name = filename;
		char* t = strrchr(filename, '\\');
		if (t) name = ++t;
		HICON hicon = ::ExtractIcon(ins, filename, 0);
		if(hicon) addIcon(name, hicon);
	}
	update(NULL);
	return NULL;
}



void	Main(int argc, char** argv)
{
	const char* appClass = "IconViewer";
	Application applet(appClass, argc, argv);

	Args args;
	args.set(XmNexStyle, (ulong)WS_EX_ACCEPTFILES);
	IconViewer iconViewer(applet, appClass, args);
	iconViewer.setNumPerLine(5);
	iconViewer.setPitch(100);
	iconViewer.realize();

	applet.run();
}

