/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ImageBrowser.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.07.26

#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\FileDialog.h>
#include <sol\ClientDC.h>
#include <sol\DIBSection.h>
#include <sol\AffineTransform.h>
#include <sol\HighlightFilter.h>
#include <sol\GrayScaleFilter.h>
#include "resource.h"


class ImageBrowser :public ApplicationView {
	DIBSection	loadedImage;
	FileDialog	fileDialog;
	DIBSection*	rotatedImage;
	DIBSection* grayImage;

	DIBSection*	brightImage;

	long	close(Event& event) {
		savePlacement();
		return defaultProc(event);
	}

	void	open(Action& action) {
		if (fileDialog.open()) {
			char title[MAX_PATH];
			char* filename = fileDialog.getFileName();
			Printf("ImageName %s\r\n", filename);
			ClientDC cdc(this);
			loadedImage.load(cdc, filename);
			
			GrayScaleFilter gfilter;

			delete grayImage;
			grayImage = gfilter.filterRGB(cdc, loadedImage);

		
			HighlightFilter hfilter(40);

			Printf("ImageName 2 %s\r\n", filename);
		
			delete brightImage;
			brightImage = hfilter.filterRGB(cdc, loadedImage);
	
			AffineTransform transform;
			Printf("ImageName 1 %s\r\n", filename);
			
			delete rotatedImage;
			rotatedImage = transform.rotate(cdc, loadedImage, 30.0);

			sprintf(title, "%s - ImageBrowser", filename);
			setText(title);
			update(NULL);
		}
	}

	long paint(Event& event)
	{
		PaintDC pdc(this);
		loadedImage.draw(pdc, 10, 10);
		int gap = 100;
		if (grayImage) {
			grayImage->draw(pdc, 10+gap, 10+gap);
		}
	
		if (brightImage) {
			brightImage->draw(pdc, 10+gap*2, 10+gap*2);
		}
		
		if (rotatedImage) {
			rotatedImage->draw(pdc, 10+gap*3, 10+gap*3);
		}

		return 0;
	}

  public:
	ImageBrowser(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, args)
	{
		grayImage    = NULL;
		brightImage  = NULL;
		rotatedImage = NULL;
		
		ClientDC cdc(this);
		
		char dir[MAX_PATH];
		GetWindowsDirectory(dir, MAX_PATH);
		Args ar;
		ar.set(XmNfilter, "Bitmap files \0*.bmp\0");
		ar.set(XmNdirectory, dir);
		fileDialog.create(this, "", ar);

		addCallback(XmNmenuCallback, IDM_OPEN, this,
			(Callback)&ImageBrowser::open, NULL);
	
		addCallback(XmNmenuCallback, IDM_EXIT, this,
			(Callback)&ImageBrowser::exit, NULL);

		addEventHandler(WM_PAINT, this, (Handler)&ImageBrowser::paint, null);
		addEventHandler(WM_CLOSE, this, (Handler)&ImageBrowser::close, null);

		restorePlacement();
	}

	~ImageBrowser() {
		delete grayImage;
		delete brightImage;
		delete rotatedImage;
	}
};

void	Main(int argc, char** argv)
{
	const char* name = "ImageBrowser";
	Application applet(name, argc, argv);

	Args args;
	args.set(XmNexStyle,(ulong)WS_EX_CLIENTEDGE);

	ImageBrowser imageTransform(applet, name, args);
	imageTransform.realize();
	applet.run();
}
