/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Installer.cpp
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.25 Modified
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PushButton.h>
#include <sol\paintdc.h>
#include <sol\stdio.h>
#include <dde.h>


class Installer :public ApplicationView {
	HWND	hserver;
	HANDLE	hdata;
	ATOM	app;
	ATOM	topic;
	BOOL	ddeTry;
	BOOL	ddeStatus;
	PushButton pushb;
	PushButton itemb;
	char*	groupName;
	void	group(Action& action);
	void	addItem(Action& action);
	long	ddeAck(Event& event);
	long	ddeTerminate(Event& event);
	long	close(Event& event);
  public:
	Installer(Application& applet, const char* label, Args& args);
};


Installer::Installer(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{
	groupName = "SOL++ TOOL";
	Args ar;
	pushb.create(this, "CreateGroup", ar);
	pushb.addCallback(XmNactivateCallback, this, (Callback)&Installer::group, NULL);

	ar.reset();
	ar.set(XmNx, 0);
	ar.set(XmNy, 100);
	itemb.create(this, "AddItem", ar);
	itemb.addCallback(XmNactivateCallback, this, (Callback)&Installer::addItem, NULL);

	addEventHandler(WM_DDE_ACK, this,  (Handler)&Installer::ddeAck, NULL);
	addEventHandler(WM_DDE_TERMINATE, this,  (Handler)&Installer::ddeTerminate, NULL);
	addEventHandler(WM_CLOSE, this,  (Handler)&Installer::close, NULL);

	hserver = NULL;
	hdata   = NULL;
	ddeStatus = FALSE;

	app   = GlobalAddAtom("PROGMAN");
	topic = GlobalAddAtom("PROGMAN");
	ddeTry = TRUE;
	SendMessage((HWND)0xFFFF, WM_DDE_INITIATE, (WPARAM)getWindow(),
		(LPARAM)MAKELONG(app, topic));

	GlobalDeleteAtom(app);
	GlobalDeleteAtom(topic);
}

long Installer::ddeAck(Event& event)
{
	if(ddeTry) {
	 	hserver = (HWND)event.getWParam();
		LPARAM atoms = event.getLParam();
		GlobalDeleteAtom(LOWORD(atoms));
		GlobalDeleteAtom(HIWORD(atoms));
		ddeTry = FALSE;
		Printf("DDEAck from WM_DDE_INITIATE \r\n");
	}
	if(ddeStatus) {
		if(hdata) {
			GlobalUnlock(hdata);
			GlobalFree(hdata);
			ddeStatus = FALSE;
			hdata     = NULL;
		}
		Printf("DDEAck from WM_DDE_EXECUTE \r\n");		   		
	}
	return 0L;
}


void Installer::group(Action& action)
{
	if(hserver) {
		ddeStatus = TRUE;
		hdata = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, 256);
		char* command = (char*)GlobalLock(hdata);
		sprintf(command, "[CreateGroup(\"%s\",Windows)] [ShowGroup(\"%s\",1)]",
			groupName, groupName);

			Printf("command %s \r\n", command);		 
			PostMessage(hserver, WM_DDE_EXECUTE,
				(WPARAM)getWindow(), (LPARAM)hdata);
	}	
}


void Installer::addItem(Action& action)
{
	if(hserver) {
		ddeStatus = TRUE;
		hdata = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, 256);
		char* command = (char*)GlobalLock(hdata);

		char* path ="C:\\app\\console\\console.exe";
		char* title = "Debug support tool";
		sprintf(command, "[ShowGroup(%s, 1)][AddItem(%s, %s)]",
					groupName, path, title);

		PostMessage(hserver, WM_DDE_EXECUTE,
			(WPARAM)getWindow(), (LPARAM)hdata);
	}	
}

long Installer::ddeTerminate(Event& event)
{
	Printf("I got DDE_TERMINATE \r\n");	
	PostMessage(hserver, WM_DDE_TERMINATE, (WPARAM)getWindow(), 0L);
	hserver = NULL;
	return 0L;
}


void WaitMessage(HWND hwnd, DWORD count, UINT message)
{
		DWORD ctime = GetCurrentTime();
		while((GetCurrentTime() - ctime) < count) {
			MSG msg;
			if(PeekMessage(&msg, hwnd, message, message, PM_REMOVE)) {
				break;
			}
		}
}


long Installer::close(Event& event)
{
	if(hserver) {
		HWND hwnd = getWindow();
		PostMessage(hserver, WM_DDE_TERMINATE, 
			(WPARAM)hwnd, NULL);
		Printf(">> WaitMessage \r\n");
//		WaitMessage(GetWindow(), 3000, WM_DDE_ACK);
		WaitMessage(getWindow(), 3000, WM_DDE_TERMINATE);

		Printf("<< WaitMessage \r\n");

		DWORD ctime = GetCurrentTime();
		while((GetCurrentTime() - ctime) < 1000) {
			MSG msg;
			if(PeekMessage(&msg, hwnd,
					WM_DDE_TERMINATE, WM_DDE_TERMINATE, PM_REMOVE)){
				break;
				}
		}
 
	}
	return defaultProc(event);
}


void	Main(int argc, char** argv)
{
	const char* appClass = "SOL++:Installer";
	Application applet(appClass, argc, argv);

	Args args;
	Installer installer(applet, appClass, args);
	installer.realize();

	applet.run();
}

