/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	LabelGadget.cpp
 *
 *****************************************************************************/


// SOL++2000
// 2000.03.20

#include <sol\ApplicationView.h>
#include <sol\LabelGadget.h>
#include <sol\PaintDC.h>


class AppView :public ApplicationView {
	LabelGadget labelg;

	long paint(Event& event) {
		PaintDC dc(this);
		for (int i = 0; i<10; i++) {
			labelg.draw(&dc, 10, 2+30*i);
		}
		return 0L;
	}

  public:
	AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args)
	{
		Args ar;
		labelg.create(this, " Hello world! ", ar);
		labelg.setBackColor(RGB(0,0,255));
		labelg.setTextColor(RGB(255,255,255));

		addEventHandler(WM_PAINT, this, (Handler)&AppView::paint, NULL);
	}
};


void Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appview(applet, name, args);
	appview.realize();
	applet.run();
}

