/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MediaControl.cpp
 *
 *****************************************************************************/



// SOL++2000

#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>

#include <sol\DesktopWindow.h>
#include <sol\Profile.h>
#include <sol\Font.h>
#include <sol\Paintdc.h>
#include <sol\Stdio.h>
#include <sol\MediaControlView.h>


class MediaControl :public ApplicationView {
	MediaControlView controller;

  public:
	MediaControl(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args)
	{
		Args ar;
		ar.set(XmNx, 10);
		ar.set(XmNy, 10);
		ar.set(XmNwidth,  100);
		ar.set(XmNheight, 100);
		//ar.set(XmNstyle, MCIWNDF_SHOWALL);

		controller.create(this, 
			"d:\\winnt\\clock.avi", ar);

	}
};

// MediaControl Main
void	Main(int argc, char** argv)
{
	const char* appClass = "MediaControl";
	Application applet(appClass, argc, argv);
		
	Args args;
	args.set(XmNclassName, appClass);
	MediaControl controller(applet, appClass, args);
	controller.realize();
	applet.run();
}

