/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PageSetup.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\PageSetupDialog.h>
#include "resource.h"


class Editor :public ApplicationView {
	ScrolledText	text;
	PageSetupDialog  pageSetup;

	void	setup(Action& action);

  public:
	Editor(Application& applet, const char* name, Args& args);
};


void Editor::setup(Action& action)
{
	pageSetup.popup(action);
	if(action.getResult()) {
		MessageBox(NULL, "PageSetup OK", "Sample", MB_OK);
	}
}


Editor::Editor(Application& applet, const char* name, Args& args) 
	:ApplicationView(applet, name, args)
{
	Args ar;
	ar.set(XmNexStyle, (ulong)WS_EX_ACCEPTFILES);
	text.create(this, "", ar);
	// 1999.09.25
	add(text);

	ar.reset();
	pageSetup.create(this, "", ar);
	addCallback(XmNmenuCallback, ID_OPTION_SETUP, this, (Callback)&Editor::setup, NULL);
}


void	Main(int argc, char** argv)
{
	const char* name = "Editor";
	Application applet(name, argc, argv);

	Args args;
	Editor editor(applet, name, args);
	editor.realize();

	applet.run();
}

