/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Pen.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\Pen.h>


class AppView :public ApplicationView {
	long paint(Event& event);
  public:
	AppView(Application& applet, const char* label, Args& args);
};


long AppView::paint(Event& event)
{
	PaintDC pdc(this);
	RECT	r;
	getClientRect(&r);
	int w = r.bottom/255+1;
	for(int i = 0; i < 255; i++) {
		int val = 255 -i;
		Pen* pen = new Pen(PS_INSIDEFRAME, w+2, RGB(255, 255, val) );

		HGDIOBJ prev = pdc.select(pen);
	
		pdc.moveTo(0, w*i, NULL);
		pdc.lineTo(r.right, w*i);
		pdc.select(prev);
		delete pen;
	}
	return NULL;
}

AppView::AppView(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{
	addEventHandler(WM_PAINT, this, (Handler)&AppView::paint, NULL);
}


void	Main(int argc, char** argv)
{
	const char* appClass = "PenEx";
	Application applet(appClass, argc, argv);

	Args args;
	AppView appview(applet, appClass, args);
	appview.realize();

	applet.run();
}

