/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Pixel.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18



#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\DesktopDC.h>


class PixelView :public ApplicationView {


	void copy(DC& destDC, int dx, int dy, int width, int height, 
		DC& sourceDC, int sx, int sy) 
	{	
		for(int y = sy; y<sy+height; y++) {
			for(int x = sx; x<sx+width; x++) {
				COLORREF color = sourceDC.getPixel(x, y);
				destDC.setPixel(x + dx, y+ dy, color);
			}
		}
	}

	long paint(Event& event)
	{
		PaintDC pdc(this);
		DesktopDC deskdc;
		copy(pdc, 20, 20, 300, 300, deskdc, 0, 0);
		return 0;
	}

  public:
	PixelView(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, args)
	{
		addEventHandler(WM_PAINT, this, (Handler)&PixelView::paint, null);
	}
};


void	Main(int argc, char** argv)
{
	const char* name = "PixelView";
	Application applet(name, argc, argv);

	Args args;
	PixelView pixelview(applet, name, args);
	pixelview.realize();
	applet.run();
}
