/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PopupView.cpp
 *
 *****************************************************************************/


// SOL++2000 sample
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\BorderLayout.h>
#include <sol\PushButton.h>
#include <sol\PopupView.h>
#include <sol\Static.h>

class PopupMessage :public PopupView {
	Static		message;
	PushButton	ok;
	BorderLayout layout;
  public:
	PopupMessage(): PopupView() { }


	virtual Boolean create(View* parent, const char* title, Args& args)
	{
		Boolean rc = PopupView::create(parent, title, args);
		setLayout(&layout);
		Args ar;
		message.create(this, "", ar);
		add(message, BorderLayout::CENTER);
		
		ar.reset();
		ok.create(this, "Popdown", ar);
		add(ok, BorderLayout::SOUTH);
		// Call resize method to layout imediately.
		resize();		

		//<font color="green"> Register callback to ok button to pop down this window.</font>
		ok.addCallback(XmNactivateCallback, this,
					(Callback)&PopupMessage::popdown, null);
		return rc;
	}

	void	setMessage(const char* text) {
		message.setText(text);
	}
};


class MainView :public ApplicationView {
	PushButton	   popupb;
    PopupMessage  message;

  public:
    //<font color="green"> Constructor</font>
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        //<font color="green"> Create an instance of ToolBar.</font>
        popupb.create(this, "Popup a PopupMessage", ar);
        add(popupb);

		ar.reset();
		ar.set(XmNwidth,  300);
		ar.set(XmNheight, 100);
		ar.set(XmNstyle, (ulong)WS_THICKFRAME|WS_MINIMIZEBOX|WS_SYSMENU);

		message.create(this, "PopupMessage", ar);
		message.setMessage("This is a PopupView");

        //<font color="green"> Register popup callback of PopupMessage class to the popupb.</font>
        popupb.addCallback(XmNactivateCallback, &message, 
			(Callback)&PopupView::popup, NULL);
    }

};


void Main(int argc, char** argv)
{
    const char* appClass = "Sample";
    Application applet(appClass, argc, argv);

    Args  args;
	args.set(XmNwidth, 300);
	args.set(XmNheight, 200);
    MainView view(applet, "Sample", args);
    view.realize(); 

    applet.run();
}

