/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	AboutDialog.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PrintDialog.h>

#define IDM_PRINT	1001


class AppView :public ApplicationView {
	PrintDialog	printdlg;

	void	print(Action& action)
	{
		printdlg.popup(action);
		if (action.getResult()) {
			HDC hdc = printdlg.getDC();
			char* doc = "TEXT";
			DOCINFO docInfo;
			memset(&docInfo, 0, sizeof(DOCINFO));
			docInfo.cbSize = sizeof(DOCINFO);
			docInfo.lpszDocName = "Text";

			StartDoc(hdc, &docInfo); 
			StartPage(hdc);
	
			char* text = "Hello world";
			TextOut(hdc, 200, 200, text, strlen(text));
			EndPage(hdc);
			EndDoc(hdc);
		}
	}

  public:
	AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args)
	{
		Args ar;
		printdlg.create(this,"", ar);
		addCallback(XmNmenuCallback, IDM_PRINT, this,
			(Callback)&AppView::print, null);
	}
};


void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appView(applet, name, args);
	appView.realize();
	applet.run();
}

