/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ProgressBar.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\ProgressBar.h>


class AppView :public ApplicationView {
	ProgressBar	progress;

	long	timer(Event& event);
	long	close(Event& event);
public:
	AppView(Application& applet, const char* label, Args& args);
};

	
AppView::AppView(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{  
	Args ar;
	ar.set(XmNwidth, 200);
	ar.set(XmNheight, 20);
	progress.create(this, "", ar);
	progress.setRange(0, 20);
	progress.setStep(1);

	setTimer(10, 100, NULL);
	addEventHandler(WM_TIMER, this, (Handler)&AppView::timer, NULL);
	addEventHandler(WM_CLOSE, this, (Handler)&AppView::close, NULL);
}


long AppView::timer(Event& event) 
{
	progress.stepIt();
	return 0;
}

long AppView::close(Event& event) 
{
	::MessageBox(NULL, "Close this window! ", "Confirmation", MB_OK);
	killTimer(10);
	destroyWindow();
	return 0;
}


void	Main(int argc, char** argv)
{
	const char* name = "ProgressBar";
	Application applet(name, argc, argv);

	Args args;
	AppView appview(applet, name, args);
	appview.realize();

	applet.run();
}

