/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	QuickSort.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\Stdio.h>
#include <sol\QuickSorter.h>
#include <sol\ScrolledText.h>
#include <sol\String.h>


class AppFrame :public ApplicationView {
	ScrolledText text;
	long	start(Event& event);

  public:
    AppFrame(Application& applet, const char* label, Args& args);
};

AppFrame::AppFrame(Application& applet, const char* label, Args& args)
        :ApplicationView(applet, label, args)
{
	Args ar;
	text.create(this, "", ar);
	add(text);

	// Add an eventhandler start to handle a user-defined event.
	addEventHandler(WM_USER+300, this, (Handler)&AppFrame::start, null);

	// Post the user-defined event.
	post(WM_USER+300, 0, 0);
}


long AppFrame:: start(Event& event) 
{
	static	int integers[] = {
		1, 200, 3, 11, 0,
		500, 20, 600, 30
	};

	static char* strings[] = {
		"orange", "banana", "apple", "melon", "grape",
	};

	QuickSorter qsorter1;
	// Sort an array of integers.
	qsorter1.sort(integers, XtNumber(integers));
	qsorter1.wait();

	// Sort an array of char*.
	QuickSorter	qsorter2;
	qsorter2.sort(strings,  XtNumber(strings));
	qsorter2.wait();

	static Object* objects[10];
	int num = 0;
	objects[num++] = new String("dog");
	objects[num++] = new String("sheep");
	objects[num++] = new String("pig");
	objects[num++] = new String("cat");
	objects[num++] = new String("hen");
	objects[num++] = new String("ox");

	// Sort an array of instances of String.
	QuickSorter qsorter3;
	qsorter3.sort(objects, num);
	qsorter3.wait();

	int i = 0;
	for (i = 0; i<XtNumber(integers); i++) {
			text.printf("%d \r\n", integers[i]);
	}

	text.printf("--------------------\r\n");

	for (i = 0; i<XtNumber(strings); i++) {
		text.printf("%s \r\n", strings[i]);
	}
	text.printf("--------------------\r\n");

	for (i = 0; i<num; i++) {
		String* string = (String*)objects[i];
		text.printf("%s \r\n", (const char*)(*string));
	}

	return 0L;
}


void Main(int argc, char** argv)
{
    const char* appClass = "QuickSort";
    Application applet(appClass, argc, argv);

    Args  args;
    AppFrame frame(applet, appClass, args);
    frame.realize(); 

    applet.run();
}
