/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	RubberBand.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\ClientDC.h>
#include <sol\StockObject.h>


class MainView :public ApplicationView {
	POINT	beg;
	POINT	end;
	int		capturing;

	long	leftButtonDown(Event& event);
	long	mouseMove(Event& event);
	long	leftButtonUp(Event& event);
  public:
	MainView(Application& applet, const char* label, Args& args);
};


MainView::MainView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	capturing = FALSE;
	addEventHandler(WM_LBUTTONDOWN, this, (Handler)&MainView::leftButtonDown, NULL);
	addEventHandler(WM_MOUSEMOVE, this, (Handler)&MainView::mouseMove, NULL);
	addEventHandler(WM_LBUTTONUP, this, (Handler)&MainView::leftButtonUp, NULL);
}


long MainView::leftButtonDown(Event& event)
{
	event.getMousePosition(&beg);
	end.x     = beg.x;
	end.y     = beg.y;
	capturing = TRUE;
	return 0;
}


long MainView::mouseMove(Event& event)
{
	ClientDC cdc(this);

	StockObject brush(NULL_BRUSH);
	cdc.select(&brush);
	cdc.setROP2(R2_NOTXORPEN);
	if(capturing == TRUE) {
		cdc.rectangle(beg.x, beg.y, end.x, end.y);
		event.getMousePosition(&end);
		cdc.rectangle(beg.x, beg.y, end.x, end.y);
	}
	return 0;
}


long MainView::leftButtonUp(Event& event)
{
	capturing = FALSE;
	return 0;
}



void Main(int argc, char** argv) 
{
	const char* name = "RubberBand";
	Application applet(name, argc, argv);

	Args args;
	MainView mainView(applet, name, args);
	mainView.realize();
	applet.run();
}
